/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.consumers.launchpad;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Optional;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.displaymodellib.transformations.TransformationUtils;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.ConfigPanelBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.panels.config.ConfigPanel;
import org.metamechanists.quaptics.panels.config.implementation.LaunchpadConfigPanel;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class Launchpad
extends ConnectedBlock
implements ConfigPanelBlock,
PowerAnimatedBlock {
    public static final Settings LAUNCHPAD_SETTINGS = Settings.builder().tier(Tier.BASIC).minPower(30.0).minFrequency(2.0).build();
    public static final SlimefunItemStack LAUNCHPAD = new SlimefunItemStack("QP_LAUNCHPAD", Material.LIGHT_GRAY_CONCRETE, "&7Launchpad", Lore.create(LAUNCHPAD_SETTINGS, "&7\u25cf Launches players", "&7\u25cf Launch velocity can be configured", "&7\u25cf &eWalk onto the launchpad &7to get launched"));
    private static final Vector INITIAL_VELOCITY = new Vector(0, 0, 0);
    private static final float VELOCITY_POWER = 1.5f;
    private static final float VELOCITY_DIVISOR = 5.0f;
    public static final float MAX_VELOCITY = 10.0f;
    private static final Vector RELATIVE_PANEL_LOCATION = new Vector(0.0f, 0.0f, -0.51f);
    private final Vector inputPointLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());

    public Launchpad(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.8f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("plate", new ModelCuboid().material(Material.LIGHT_BLUE_CONCRETE).brightness(3).location(0.0f, 0.5f, 0.0f).size(0.8f, 0.1f, 0.8f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", Launchpad.formatPointLocation(player, location, this.inputPointLocation)));
    }

    @Override
    protected void initBlockStorage(@NotNull Location location) {
        BlockStorageAPI.set(location, "QP_VELOCITY", INITIAL_VELOCITY);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onPlace(@NotNull BlockPlaceEvent event) {
        super.onPlace(event);
        this.onPlaceConfigPanelBlock(event);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onBreak(@NotNull Location location) {
        super.onBreak(location);
        this.onBreakConfigPanelBlock(location);
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (this.doBurnoutCheck(group, "input")) {
            return;
        }
        Optional<Link> inputLink = Launchpad.getLink(location, "input");
        this.onPoweredAnimation(location, inputLink.isPresent() && this.settings.isOperational(inputLink));
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "plate", powered);
    }

    @Override
    public ConfigPanel createPanel(Location location, Player player, @NotNull ConnectionGroup group) {
        return new LaunchpadConfigPanel(Launchpad.formatPointLocation(player, location, RELATIVE_PANEL_LOCATION), group.getId(), (float)TransformationUtils.yawToCardinalDirection(player.getEyeLocation().getYaw()));
    }

    @Override
    public ConfigPanel getPanel(ConfigPanelId panelId, ConnectionGroupId groupId) {
        return new LaunchpadConfigPanel(panelId, groupId);
    }

    @Override
    @NotNull
    protected Material getBaseMaterial() {
        return Material.LIGHT_GRAY_CONCRETE;
    }

    public void launch(Location location, Player player) {
        Optional<Link> inputLink = Launchpad.getLink(location, "input");
        if (inputLink.isEmpty() || !this.settings.isOperational(inputLink)) {
            return;
        }
        Optional<Vector> velocity = BlockStorageAPI.getVector(location, "QP_VELOCITY");
        if (velocity.isEmpty()) {
            return;
        }
        velocity.get().setX(Launchpad.calculateFinalVelocity(velocity.get().getX()));
        velocity.get().setY(Launchpad.calculateFinalVelocity(velocity.get().getY()));
        velocity.get().setZ(Launchpad.calculateFinalVelocity(velocity.get().getZ()));
        velocity.get().multiply(0.2);
        player.setVelocity(velocity.get());
    }

    private static double calculateFinalVelocity(double velocity) {
        return velocity >= 0.0 ? Math.pow(velocity, 1.5) : -Math.pow(Math.abs(velocity), 1.5);
    }
}

