/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.consumers;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Optional;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelItem;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.InfoPanelBlock;
import org.metamechanists.quaptics.implementation.attachments.ItemHolderBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.attachments.ProgressBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.panels.info.BlockInfoPanel;
import org.metamechanists.quaptics.panels.info.implementation.ProgressInfoPanel;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Language;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;

public class DataStripper
extends ConnectedBlock
implements InfoPanelBlock,
ItemHolderBlock,
ProgressBlock,
PowerAnimatedBlock {
    public static final Settings DATA_STRIPPER_1_SETTINGS = Settings.builder().tier(Tier.BASIC).timePerItem(30.0).minPower(15.0).minFrequency(8.0).build();
    public static final Settings DATA_STRIPPER_2_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).timePerItem(8.0).minPower(180.0).minFrequency(100.0).build();
    public static final SlimefunItemStack DATA_STRIPPER_1 = new SlimefunItemStack("QP_DATA_STRIPPER_1", Material.DEEPSLATE_BRICK_SLAB, "&7Data Stripper &fI", Lore.create(DATA_STRIPPER_1_SETTINGS, "&7\u25cf Converts Slimefun heads into regular placeable heads", "&7\u25cf &eRight Click &7with an item to insert"));
    public static final SlimefunItemStack DATA_STRIPPER_2 = new SlimefunItemStack("QP_DATA_STRIPPER_2", Material.DEEPSLATE_BRICK_SLAB, "&7Data Stripper &fII", Lore.create(DATA_STRIPPER_2_SETTINGS, "&7\u25cf Converts Slimefun heads into regular placeable heads", "&7\u25cf &eRight Click &7with an item to insert"));
    private static final double MAX_PROGRESS_DIFFERENCE = 1.0E-5;
    private final Vector inputPointLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());

    public DataStripper(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.4f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("mainTop", new ModelCuboid().block(Material.DEEPSLATE_BRICK_SLAB.createBlockData("[type=top]")).location(0.0f, 0.35f, 0.0f).size(0.5f, 0.3f, 0.5f)).add("mainBottom", new ModelCuboid().block(Material.DEEPSLATE_BRICK_SLAB.createBlockData("[type=bottom]")).location(0.0f, -0.35f, 0.0f).size(0.5f, 0.3f, 0.5f)).add("glassTop", new ModelCuboid().material(this.settings.getTier().concreteMaterial).brightness(3).location(0.0f, 0.35f, 0.0f).size(0.3f, 0.15f, 0.3f)).add("glassBottom", new ModelCuboid().material(this.settings.getTier().concreteMaterial).brightness(3).location(0.0f, -0.35f, 0.0f).size(0.3f, 0.15f, 0.3f)).add("item", new ModelItem().facing(player.getFacing()).location(0.0f, 0.125f, 0.0f).size(0.5f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", DataStripper.formatPointLocation(player, location, this.inputPointLocation)));
    }

    @Override
    protected void initBlockStorage(@NotNull Location location) {
        ProgressBlock.setProgress(location, 0.0);
    }

    @Override
    protected boolean isTicker() {
        return true;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onPlace(@NotNull BlockPlaceEvent event) {
        super.onPlace(event);
        this.onPlaceInfoPanelBlock(event);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onBreak(@NotNull Location location) {
        super.onBreak(location);
        this.onBreakInfoPanelBlock(location);
        this.onBreakItemHolderBlock(location, "item");
    }

    @Override
    protected boolean onRightClick(@NotNull Location location, @NotNull Player player) {
        this.itemHolderInteract(location, "item", player);
        return true;
    }

    @Override
    public void onTick10(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (!BlockStorageAPI.getBoolean(location, "QP_IS_HOLDING_ITEM")) {
            this.setPanelHidden(group, true);
            return;
        }
        this.setPanelHidden(group, ItemHolderBlock.getStack(group, "item").isEmpty());
        Optional<Link> inputLink = DataStripper.getLink(group, "input");
        if (inputLink.isEmpty() || !this.settings.isOperational(inputLink)) {
            return;
        }
        if (ItemHolderBlock.getStack(location, "item").isPresent()) {
            ProgressBlock.updateProgress(location, 10.0, this.settings.getTimePerItem());
        }
        this.updatePanel(group);
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        this.doBurnoutCheck(group, "input");
        Optional<Link> inputLink = DataStripper.getLink(location, "input");
        this.onPoweredAnimation(location, this.settings.isOperational(inputLink));
    }

    @Override
    public boolean onInsert(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack, @NotNull Player player) {
        if (SlimefunItem.getByItem((ItemStack)stack) == null || stack.getType() != Material.PLAYER_HEAD) {
            Language.sendLanguageMessage(player, "data-stripper.not-slimefun-head", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public Optional<ItemStack> onRemove(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack) {
        double progress = ProgressBlock.getProgress(location);
        ProgressBlock.setProgress(location, 0.0);
        return Math.abs(progress - this.settings.getTimePerItem()) < 1.0E-5 ? Optional.of(DataStripper.stripData(stack)) : Optional.of(stack);
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "glassTop", powered);
        this.brightnessAnimation(location, "glassBottom", powered);
    }

    @Override
    public BlockInfoPanel createPanel(Location location, @NotNull ConnectionGroup group) {
        return new ProgressInfoPanel(location, group.getId());
    }

    @Override
    public BlockInfoPanel getPanel(InfoPanelId panelId, ConnectionGroupId groupId) {
        return new ProgressInfoPanel(panelId, groupId);
    }

    @NotNull
    private static ItemStack stripData(@NotNull ItemStack inputStack) {
        ItemStack intermediaryStack = inputStack.clone();
        SkullMeta itemMeta = (SkullMeta)intermediaryStack.getItemMeta();
        ItemStack outputStack = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta outputMeta = (SkullMeta)outputStack.getItemMeta();
        outputMeta.setOwnerProfile(itemMeta.getOwnerProfile());
        outputStack.setItemMeta((ItemMeta)outputMeta);
        return outputStack;
    }
}

