/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.attachments;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.event.block.BlockPlaceEvent;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.panels.info.BlockInfoPanel;
import org.metamechanists.quaptics.panels.info.InfoPanelContainer;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;

public interface InfoPanelBlock {
    public static Optional<InfoPanelId> getPanelId(Location location) {
        return BlockStorageAPI.getInfoPanelId(location, "QP_PANEL_ID");
    }

    public static void setPanelId(Location location, @NotNull InfoPanelId id) {
        BlockStorageAPI.set(location, "QP_PANEL_ID", id);
    }

    default public void updatePanel(@NotNull ConnectionGroup group) {
        Optional<Location> location = group.getLocation();
        if (location.isEmpty()) {
            return;
        }
        Optional<InfoPanelId> id = InfoPanelBlock.getPanelId(location.get());
        id.ifPresent(panelId -> this.getPanel((InfoPanelId)panelId, group.getId()).update());
    }

    default public void setPanelHidden(@NotNull ConnectionGroup group, boolean hidden) {
        Optional<Location> location = group.getLocation();
        if (location.isEmpty()) {
            return;
        }
        Optional<InfoPanelId> id = InfoPanelBlock.getPanelId(location.get());
        id.ifPresent(panelId -> this.getPanel((InfoPanelId)panelId, group.getId()).setPanelHidden(hidden));
    }

    default public void onPlaceInfoPanelBlock(@NotNull BlockPlaceEvent event) {
        Location location = event.getBlock().getLocation();
        Optional<ConnectionGroup> optionalGroup = ConnectedBlock.getGroup(location);
        optionalGroup.ifPresent(group -> InfoPanelBlock.setPanelId(location, this.createPanel(location, (ConnectionGroup)optionalGroup.get()).getId()));
    }

    default public void onBreakInfoPanelBlock(@NotNull Location location) {
        InfoPanelBlock.getPanelId(location).flatMap(InfoPanelId::get).ifPresent(InfoPanelContainer::remove);
    }

    public BlockInfoPanel createPanel(Location var1, @NotNull ConnectionGroup var2);

    public BlockInfoPanel getPanel(InfoPanelId var1, ConnectionGroupId var2);
}

