/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.info.implementation;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.implementation.multiblocks.reactor.ReactorController;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.panels.info.BlockInfoPanel;
import org.metamechanists.quaptics.panels.info.InfoPanelBuilder;
import org.metamechanists.quaptics.panels.info.InfoPanelContainer;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;

public class ReactorInfoPanel
extends BlockInfoPanel {
    public ReactorInfoPanel(@NotNull Location location, ConnectionGroupId groupId) {
        super(location, groupId);
    }

    public ReactorInfoPanel(@NotNull InfoPanelId panelId, ConnectionGroupId groupId) {
        super(panelId, groupId);
    }

    @Override
    protected InfoPanelContainer buildPanelContainer(@NotNull Location location) {
        return new InfoPanelBuilder(location.clone().toCenterLocation().add(this.getOffset()), 0.4f).addAttribute("thresholdBar", false).addAttribute("efficiencyBar", false).addAttribute("powerOutputText", false).build();
    }

    @Override
    public void update() {
        if (this.isPanelHidden()) {
            return;
        }
        Optional<ConnectionGroup> group = this.getGroup();
        if (group.isEmpty()) {
            return;
        }
        Optional<Location> location = group.get().getLocation();
        if (location.isEmpty()) {
            return;
        }
        ConnectedBlock block = group.get().getBlock();
        if (!(block instanceof ReactorController)) {
            return;
        }
        ReactorController controller = (ReactorController)block;
        Settings settings = group.get().getBlock().getSettings();
        double secondsSinceStarted = BlockStorageAPI.getDouble(location.get(), "QP_TIME_SINCE_REACTOR_STARTED");
        double maxSeconds = group.get().getBlock().getSettings().getTimeToMaxEfficiency();
        double inputPower = ReactorController.getTotalInputPower(location.get());
        double minInputPower = settings.getPowerThreshold();
        double outputPower = BlockStorageAPI.getDouble(location.get(), "QP_OUTPUT_POWER");
        double maxOutputPower = controller.getMaxOutputPower();
        this.container.setText("thresholdBar", "&7Threshold " + Lore.thresholdBar(inputPower, minInputPower));
        this.container.setText("efficiencyBar", "&7Efficiency " + Lore.efficiencyBar(secondsSinceStarted, maxSeconds));
        this.container.setText("powerOutputText", "&7Output " + Lore.powerOutput(outputPower, maxOutputPower));
    }

    @Override
    protected Vector getOffset() {
        return new Vector(0.0, 0.9, 0.0);
    }
}

