/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.metalib.sefilib.misc;

import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;
import org.metamechanists.quaptics.metalib.sefilib.misc.RotationFace;

public final class TransformationBuilder {
    private AxisAngle4f firstRotation = new AxisAngle4f(0.0f, 0.0f, 1.0f, 0.0f);
    private AxisAngle4f secondRotation = new AxisAngle4f(0.0f, 0.0f, 1.0f, 0.0f);
    private Vector3f scaling = new Vector3f(1.0f, 1.0f, 1.0f);
    private Vector3f translation = new Vector3f(0.0f, 0.0f, 0.0f);

    public TransformationBuilder firstRotation(RotationFace face, float angle) {
        this.firstRotation = new AxisAngle4f((float)Math.toRadians(angle), face.getX(), face.getY(), face.getZ());
        return this;
    }

    public TransformationBuilder secondRotation(RotationFace face, float angle) {
        this.secondRotation = new AxisAngle4f((float)Math.toRadians(angle), face.getX(), face.getY(), face.getZ());
        return this;
    }

    public TransformationBuilder scale(float scaleX, float scaleY, float scaleZ) {
        this.scaling = new Vector3f(scaleX, scaleY, scaleZ);
        return this;
    }

    public TransformationBuilder translation(float deltaX, float deltaY, float deltaZ) {
        this.translation = new Vector3f(deltaX, deltaY, deltaZ);
        return this;
    }

    public Transformation build() {
        return new Transformation(this.translation, this.firstRotation, this.scaling, this.secondRotation);
    }
}

