/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.items;

import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.utils.Colors;

public enum Tier {
    PRIMITIVE(Colors.PRIMITIVE.getFormattedColor() + "Primitive", Material.BROWN_CONCRETE, Material.BROWN_STAINED_GLASS, 10.0),
    BASIC(Colors.BASIC.getFormattedColor() + "Basic", Material.GREEN_CONCRETE, Material.GREEN_STAINED_GLASS, 100.0),
    INTERMEDIATE(Colors.INTERMEDIATE.getFormattedColor() + "Intermediate", Material.YELLOW_CONCRETE, Material.YELLOW_STAINED_GLASS, 1000.0),
    ADVANCED(Colors.ADVANCED.getFormattedColor() + "Advanced", Material.RED_CONCRETE, Material.RED_STAINED_GLASS, 10000.0),
    TESTING("&8Testing", Material.RED_CONCRETE, Material.RED_STAINED_GLASS, 10.0);

    public final String name;
    public final Material concreteMaterial;
    public final Material glassMaterial;
    public final double maxPower;

    private Tier(String name, Material concreteMaterial, Material glassMaterial, double maxPower) {
        this.name = name;
        this.concreteMaterial = concreteMaterial;
        this.glassMaterial = glassMaterial;
        this.maxPower = maxPower;
    }

    public static boolean greaterOrEqual(@NotNull Tier t1, Tier t2) {
        switch (t1) {
            case PRIMITIVE: {
                return true;
            }
            case BASIC: {
                return t2 == BASIC || t2 == INTERMEDIATE || t2 == ADVANCED;
            }
            case INTERMEDIATE: {
                return t2 == INTERMEDIATE || t2 == ADVANCED;
            }
            case ADVANCED: {
                return t2 == ADVANCED;
            }
            case TESTING: {
                return false;
            }
        }
        return false;
    }
}

