/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.tools.targetingwand;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Keys;
import org.metamechanists.quaptics.utils.Language;
import org.metamechanists.quaptics.utils.PersistentDataUtils;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;

public class TargetingWand
extends SlimefunItem {
    public static final SlimefunItemStack TARGETING_WAND = new SlimefunItemStack("QP_TARGETING_WAND", Material.BLAZE_ROD, "&bTargeting Wand", new String[]{"&7\u25cf &eRight Click &7to select a source", "&7\u25cf &eRight Click &7again to create a link", "&7\u25cf &eShift Right Click &7to remove a link"});
    private static final float MIN_POINT_SEPARATION = 1.0E-4f;

    public TargetingWand(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    private static boolean isSourceSet(@NotNull ItemStack stack) {
        return stack.getItemMeta().getPersistentDataContainer().has(Keys.SOURCE);
    }

    private static void setSource(Player player, @NotNull ConnectionPointId sourceId, ItemStack stack) {
        Object source = sourceId.get();
        if (((Optional)source).isEmpty()) {
            return;
        }
        if (!((ConnectionPoint)((Optional)source).get()).isOutput()) {
            Language.sendLanguageMessage(player, "targeting-wand.source-must-be-output", new Object[0]);
            return;
        }
        ((ConnectionPoint)((Optional)source).get()).select();
        PersistentDataUtils.setString(stack, Keys.SOURCE, sourceId.toString());
    }

    public static void unsetSource(ItemStack stack) {
        if (TargetingWand.isSourceSet(stack)) {
            ConnectionPointId sourcePointId = new ConnectionPointId(PersistentDataUtils.getString(stack, Keys.SOURCE));
            Object sourcePoint = sourcePointId.get();
            ((Optional)sourcePoint).ifPresent(ConnectionPoint::deselect);
        }
        PersistentDataUtils.clear(stack, Keys.SOURCE);
    }

    private static void removeLink(@NotNull ConnectionPointId pointId) {
        Object point = pointId.get();
        if (((Optional)point).isEmpty()) {
            return;
        }
        ((ConnectionPoint)((Optional)point).get()).getLink().ifPresent(Link::remove);
    }

    private static void createLink(Player player, @NotNull ConnectionPointId inputId, ItemStack stack) {
        ConnectionPointId outputId = new ConnectionPointId(PersistentDataUtils.getString(stack, Keys.SOURCE));
        Object output = outputId.get();
        Object input = inputId.get();
        if (((Optional)output).isEmpty() || ((Optional)input).isEmpty()) {
            return;
        }
        if (!((ConnectionPoint)((Optional)input).get()).isInput()) {
            Language.sendLanguageMessage(player, "targeting-wand.target-must-be-input", new Object[0]);
            return;
        }
        Optional<Location> inputLocation = ((ConnectionPoint)((Optional)input).get()).getLocation();
        Optional<Location> outputLocation = ((ConnectionPoint)((Optional)output).get()).getLocation();
        if (inputLocation.isEmpty() || outputLocation.isEmpty()) {
            return;
        }
        Optional<ConnectionGroup> outputGroup = ((ConnectionPoint)((Optional)output).get()).getGroup();
        Optional<ConnectionGroup> inputGroup = ((ConnectionPoint)((Optional)input).get()).getGroup();
        if (outputGroup.isEmpty() || inputGroup.isEmpty()) {
            return;
        }
        if (!outputLocation.get().getWorld().getUID().equals(inputLocation.get().getWorld().getUID())) {
            Language.sendLanguageMessage(player, "targeting-wand.different-worlds", new Object[0]);
            return;
        }
        if (outputLocation.get().distance(inputLocation.get()) < (double)1.0E-4f) {
            Language.sendLanguageMessage(player, "targeting-wand.same-connection-point", new Object[0]);
            return;
        }
        if (inputGroup.get().getPoints().containsValue(outputId)) {
            Language.sendLanguageMessage(player, "targeting-wand.same-connection-group", new Object[0]);
            return;
        }
        if (((ConnectionPoint)((Optional)input).get()).getLink().isPresent() && ((ConnectionPoint)((Optional)output).get()).getLink().isPresent()) {
            Optional<ConnectionPoint> inputPoint = ((ConnectionPoint)((Optional)output).get()).getLink().get().getInput();
            Optional<ConnectionPoint> outputPoint = ((ConnectionPoint)((Optional)input).get()).getLink().get().getOutput();
            if (inputPoint.isPresent() && inputPoint.get().getId().equals(inputId) && outputPoint.isPresent() && outputPoint.get().getId().equals(outputId)) {
                return;
            }
        }
        ConnectedBlock outputBlock = outputGroup.get().getBlock();
        ConnectedBlock inputBlock = inputGroup.get().getBlock();
        if (((ConnectionPoint)((Optional)input).get()).getLink().isPresent()) {
            ((ConnectionPoint)((Optional)input).get()).getLink().get().remove();
        }
        if (((ConnectionPoint)((Optional)output).get()).getLink().isPresent()) {
            ((ConnectionPoint)((Optional)output).get()).getLink().get().remove();
        }
        outputBlock.connect(outputId, inputId);
        inputBlock.connect(inputId, outputId);
        TargetingWand.setSource(player, outputId, stack);
        new Link(inputId, outputId);
    }

    public void use(Player player, @NotNull ConnectionPointId pointId, ItemStack stack) {
        Object point = pointId.get();
        if (((Optional)point).isEmpty()) {
            return;
        }
        Optional<ConnectionGroup> group = ((ConnectionPoint)((Optional)point).get()).getGroup();
        if (group.isEmpty()) {
            return;
        }
        Optional<Location> location = group.get().getLocation();
        if (location.isEmpty()) {
            return;
        }
        if (!(BlockStorageAPI.hasData(location.get()) && BlockStorageAPI.check(location.get()) instanceof ConnectedBlock && this.canUse(player, false))) {
            return;
        }
        if (player.isSneaking()) {
            TargetingWand.removeLink(pointId);
            TargetingWand.unsetSource(stack);
        } else if (TargetingWand.isSourceSet(stack)) {
            TargetingWand.createLink(player, pointId, stack);
            TargetingWand.unsetSource(stack);
        } else {
            TargetingWand.setSource(player, pointId, stack);
        }
    }
}

