/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.multiblocks.infuser;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelItem;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.ComplexMultiblock;
import org.metamechanists.quaptics.implementation.attachments.ItemHolderBlock;
import org.metamechanists.quaptics.implementation.attachments.ItemProcessor;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.implementation.multiblocks.infuser.InfusionPillar;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.items.groups.CraftingComponents;
import org.metamechanists.quaptics.metalib.utils.ParticleUtils;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Language;
import org.metamechanists.quaptics.utils.Particles;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class InfusionContainer
extends ConnectedBlock
implements ItemHolderBlock,
ComplexMultiblock,
ItemProcessor {
    public static final Settings INFUSION_CONTAINER_SETTINGS = Settings.builder().tier(Tier.BASIC).operatingPowerHidden(true).timePerItem(5.0).build();
    public static final SlimefunItemStack INFUSION_CONTAINER = new SlimefunItemStack("QP_INFUSION_CONTAINER", Material.GRAY_CONCRETE, "&6Infusion Container", Lore.create(INFUSION_CONTAINER_SETTINGS, Lore.multiblock(), "&7\u25cf Infuses items", "&7\u25cf &eRight Click &7with an item to start infusing"));
    private static final Map<Vector, ItemStack> PILLARS = Map.of(new Vector(2, 0, 0), InfusionPillar.INFUSION_PILLAR, new Vector(-2, 0, 0), InfusionPillar.INFUSION_PILLAR, new Vector(0, 0, 2), InfusionPillar.INFUSION_PILLAR, new Vector(0, 0, -2), InfusionPillar.INFUSION_PILLAR);
    private static final int PILLAR_PARTICLE_COUNT = 3;
    private static final double PILLAR_PARTICLE_ANIMATION_LENGTH_SECONDS = 0.5;
    private static final double CONTAINER_PARTICLE_RADIUS = 0.5;
    private static final int CONTAINER_PARTICLE_COUNT = 3;

    public InfusionContainer(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.0f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("base", new ModelCuboid().material(Material.GRAY_CONCRETE).facing(player.getFacing()).size(0.9f, 0.6f, 0.9f).location(0.0f, -0.3f, 0.0f)).add("pillar1", new ModelCuboid().material(Material.WHITE_CONCRETE).facing(player.getFacing()).location(-0.4f, -0.1f, -0.4f).size(0.2f, 0.8f, 0.2f)).add("pillar2", new ModelCuboid().material(Material.WHITE_CONCRETE).facing(player.getFacing()).location(-0.4f, -0.1f, 0.4f).size(0.2f, 0.8f, 0.2f)).add("pillar3", new ModelCuboid().material(Material.WHITE_CONCRETE).facing(player.getFacing()).location(0.4f, -0.1f, -0.4f).size(0.2f, 0.8f, 0.2f)).add("pillar4", new ModelCuboid().material(Material.WHITE_CONCRETE).facing(player.getFacing()).location(0.4f, -0.1f, 0.4f).size(0.2f, 0.8f, 0.2f)).add("item", new ModelItem().brightness(15).location(0.0f, 0.3f, 0.0f).size(0.5f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return new ArrayList<ConnectionPoint>();
    }

    @Override
    protected void initBlockStorage(@NotNull Location location) {
        BlockStorageAPI.set(location, "QP_CRAFT_IN_PROGRESS", false);
        BlockStorageAPI.set(location, "QP_TIME_SINCE_CRAFT_STARTED", 0.0);
    }

    @Override
    protected boolean isTicker() {
        return true;
    }

    @Override
    protected void onBreak(@NotNull Location location) {
        super.onBreak(location);
        this.onBreakItemHolderBlock(location, "item");
    }

    @Override
    protected boolean onRightClick(@NotNull Location location, @NotNull Player player) {
        if (this.multiblockInteract(location.getBlock(), player)) {
            return true;
        }
        this.itemHolderInteract(location, "item", player);
        return true;
    }

    @Override
    public void onTick22(@NotNull ConnectionGroup group, @NotNull Location location) {
        BlockStorageAPI.set(location, "QP_MULTIBLOCK_INTACT", this.isStructureValid(location.getBlock()));
    }

    @Override
    public void onTick2(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (!this.isProcessing(location)) {
            return;
        }
        if (!BlockStorageAPI.getBoolean(location, "QP_MULTIBLOCK_INTACT") || !this.allPillarsPowered(location)) {
            this.cancelProcessing(location);
        }
        double secondsSinceCraftStarted = BlockStorageAPI.getDouble(location, "QP_TIME_SINCE_CRAFT_STARTED");
        this.tickProcessing(location, 2);
        this.tickAnimation(location, secondsSinceCraftStarted);
        if (secondsSinceCraftStarted >= this.settings.getTimePerItem()) {
            this.completeProcessing(location);
        }
    }

    @Override
    public boolean onInsert(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack, @NotNull Player player) {
        if (!this.isValidRecipe(stack)) {
            Language.sendLanguageMessage(player, "infuser.cannot-be-infused", new Object[0]);
            return false;
        }
        if (!this.allPillarsPowered(location)) {
            Language.sendLanguageMessage(player, "infuser.pillars-not-powered", new Object[0]);
            return false;
        }
        this.startProcessing(location);
        return true;
    }

    @Override
    public Optional<ItemStack> onRemove(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack) {
        this.cancelProcessing(location);
        return Optional.of(stack);
    }

    @Override
    public Map<ItemStack, ItemStack> getRecipes() {
        return Map.of(CraftingComponents.BLANK_MODULE_CARD, CraftingComponents.INFUSED_MODULE_CARD, new ItemStack(Material.QUARTZ), CraftingComponents.INFUSED_FREQUENCY_CRYSTAL);
    }

    @Override
    public Map<Vector, ItemStack> getStructure() {
        return PILLARS;
    }

    @Override
    public void tickAnimation(@NotNull Location centerLocation, double timeSeconds) {
        this.getStructure().keySet().forEach(pillarLocation -> InfusionContainer.animatePillar(centerLocation, centerLocation.clone().add(pillarLocation), timeSeconds));
        InfusionContainer.animateCenter(centerLocation);
    }

    private static boolean isPillarPowered(@NotNull Location pillarLocation) {
        return BlockStorageAPI.getBoolean(pillarLocation, "QP_POWERED");
    }

    private boolean allPillarsPowered(@NotNull Location location) {
        return this.getStructure().keySet().stream().allMatch(vector -> InfusionContainer.isPillarPowered(location.clone().add(vector)));
    }

    private static void animatePillar(@NotNull Location center, @NotNull Location pillarLocation, double timeSinceCraftStarted) {
        Particles.animatedLine(Particle.ELECTRIC_SPARK, pillarLocation.clone().toCenterLocation(), center.clone().toCenterLocation(), 3, timeSinceCraftStarted % 0.5 / 0.5, 0.0);
    }

    private static void animateCenter(@NotNull Location center) {
        ParticleUtils.randomParticle(center.clone().toCenterLocation(), Particle.ENCHANTMENT_TABLE, 0.5, 3);
    }
}

