/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.upgraders;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerLossBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class Repeater
extends ConnectedBlock
implements PowerAnimatedBlock,
PowerLossBlock {
    public static final Settings REPEATER_1_SETTINGS = Settings.builder().tier(Tier.BASIC).maxPowerHidden(true).minPower(20.0).powerLoss(0.08).minFrequency(0.0).maxFrequency(5.0).frequencyStep(2.0).repeaterDelay(1).build();
    public static final Settings REPEATER_2_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).maxPowerHidden(true).minPower(190.0).powerLoss(0.06).minFrequency(10.0).maxFrequency(40.0).frequencyStep(12.0).repeaterDelay(1).build();
    public static final Settings REPEATER_3_SETTINGS = Settings.builder().tier(Tier.ADVANCED).maxPowerHidden(true).minPower(1100.0).powerLoss(0.04).minFrequency(1000.0).maxFrequency(6000.0).frequencyStep(2400.0).repeaterDelay(1).build();
    public static final SlimefunItemStack REPEATER_1 = new SlimefunItemStack("QP_REPEATER_1", Material.RED_STAINED_GLASS, "&cRepeater &4I", Lore.create(REPEATER_1_SETTINGS, "&7\u25cf Increases the frequency of a quaptic ray"));
    public static final SlimefunItemStack REPEATER_2 = new SlimefunItemStack("QP_REPEATER_2", Material.RED_STAINED_GLASS, "&cRepeater &4II", Lore.create(REPEATER_2_SETTINGS, "&7\u25cf Increases the frequency of a quaptic ray"));
    public static final SlimefunItemStack REPEATER_3 = new SlimefunItemStack("QP_REPEATER_3", Material.RED_STAINED_GLASS, "&cRepeater &4III", Lore.create(REPEATER_3_SETTINGS, "&7\u25cf Increases the frequency of a quaptic ray"));
    private final Vector inputPointLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());
    private final Vector outputPointLocation = new Vector(0.0f, 0.0f, this.getConnectionRadius());

    public Repeater(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.4f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("main", new ModelCuboid().material(Material.RED_STAINED_GLASS).facing(player.getFacing()).size(0.4f).rotation(0.7853981633974483)).add("prism", new ModelCuboid().material(this.settings.getTier().concreteMaterial).facing(player.getFacing()).rotation(0.7853981633974483).size(0.3f, 0.1f, 0.3f)).add("repeater", new ModelCuboid().block(this.createRepeaterBlockData(false)).facing(player.getFacing()).location(0.0f, 0.1f, 0.0f).size(0.2f, 0.1f, 0.2f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", Repeater.formatPointLocation(player, location, this.inputPointLocation)), new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output", Repeater.formatPointLocation(player, location, this.outputPointLocation)));
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        Optional<Link> inputLink = Repeater.getLink(location, "input");
        Optional<Link> outputLink = Repeater.getLink(location, "output");
        this.onPoweredAnimation(location, this.settings.isOperational(inputLink));
        if (outputLink.isEmpty()) {
            return;
        }
        if (inputLink.isEmpty() || !this.settings.isOperational(inputLink.get())) {
            outputLink.get().disable();
            return;
        }
        outputLink.get().setPowerFrequencyPhase(PowerLossBlock.calculatePowerLoss(this.settings, inputLink.get()), Repeater.calculateFrequency(this.settings, inputLink.get().getFrequency()), inputLink.get().getPhase());
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        Optional<BlockDisplay> blockDisplay = Repeater.getBlockDisplay(location, "repeater");
        blockDisplay.ifPresent(display -> display.setBlock(this.createRepeaterBlockData(powered)));
    }

    private static double calculateFrequency(@NotNull Settings settings, double frequency) {
        return frequency + settings.getFrequencyStep();
    }

    @NotNull
    private BlockData createRepeaterBlockData(boolean powered) {
        return Material.REPEATER.createBlockData("[delay=" + this.settings.getRepeaterDelay() + ",powered=" + Objects.toString(powered) + "]");
    }
}

