/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.consumers;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Optional;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelItem;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.displaymodellib.transformations.TransformationMatrixBuilder;
import org.metamechanists.quaptics.displaymodellib.transformations.TransformationUtils;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.ConfigPanelBlock;
import org.metamechanists.quaptics.implementation.attachments.ItemHolderBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.panels.config.ConfigPanel;
import org.metamechanists.quaptics.panels.config.implementation.ItemProjectorConfigPanel;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class ItemProjector
extends ConnectedBlock
implements ItemHolderBlock,
PowerAnimatedBlock,
ConfigPanelBlock {
    public static final Settings ITEM_PROJECTOR_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).minPower(260.0).minFrequency(350.0).build();
    public static final SlimefunItemStack ITEM_PROJECTOR = new SlimefunItemStack("QP_ITEM_PROJECTOR", Material.LIGHT_BLUE_STAINED_GLASS, "&7Item Projector", Lore.create(ITEM_PROJECTOR_SETTINGS, "&7\u25cf Displays a hologram of an inserted item", "&7\u25cf &eRight Click &7with an item to insert"));
    private static final Vector RELATIVE_PANEL_LOCATION = new Vector(0.0, 0.0, -0.51);
    public static final double MAX_SIZE = 20.0;
    public static final double MAX_HEIGHT = 20.0;
    public static final int MAX_MODE = 3;
    private static final double HEIGHT_MULTIPLY = 0.1;
    private static final double SIZE_MULTIPLY = 0.1;
    private static final Vector3f ITEM_DISPLAY_ADDITIONAL_SIZE = new Vector3f(0.1f);
    private static final Vector3f ITEM_DISPLAY_ADDITIONAL_OFFSET = new Vector3f(0.0f, 0.6f, 0.0f);
    private final Vector inputPointLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());

    public ItemProjector(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.7f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("main", new ModelCuboid().material(Material.LIGHT_GRAY_CONCRETE).location(0.0f, -0.2f, 0.0f).size(1.0f, 0.6f, 1.0f)).add("prism", new ModelCuboid().block(Material.LIGHT_BLUE_STAINED_GLASS.createBlockData()).brightness(3).location(0.0f, 0.1f, 0.0f).size(0.6f, 0.1f, 0.6f).rotation(0.7853981633974483)).add("item", new ModelItem().viewRange(0).billboard(Display.Billboard.VERTICAL).brightness(15)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", ItemProjector.formatPointLocation(player, location, this.inputPointLocation)));
    }

    @Override
    protected void initBlockStorage(@NotNull Location location) {
        BlockStorageAPI.set(location, "QP_HEIGHT", 0);
        BlockStorageAPI.set(location, "QP_SIZE", ItemProjector.ITEM_DISPLAY_ADDITIONAL_SIZE.x);
        BlockStorageAPI.set(location, "QP_MODE", 0);
        ItemProjector.onConfigUpdated(location);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onPlace(@NotNull BlockPlaceEvent event) {
        super.onPlace(event);
        this.onPlaceConfigPanelBlock(event);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onBreak(@NotNull Location location) {
        super.onBreak(location);
        this.onBreakConfigPanelBlock(location);
        this.onBreakItemHolderBlock(location, "item");
    }

    @Override
    protected boolean onRightClick(@NotNull Location location, @NotNull Player player) {
        this.itemHolderInteract(location, "item", player);
        return true;
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (this.doBurnoutCheck(group, "input")) {
            return;
        }
        Optional<Link> inputLink = ItemProjector.getLink(group, "input");
        this.onPoweredAnimation(location, inputLink.isPresent() && this.settings.isOperational(inputLink));
    }

    @Override
    public boolean onInsert(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack, @NotNull Player player) {
        return true;
    }

    @Override
    public Optional<ItemStack> onRemove(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack) {
        return Optional.of(stack);
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "prism", powered);
        this.visibilityAnimation(location, "item", powered);
    }

    @Override
    public ConfigPanel createPanel(Location location, Player player, @NotNull ConnectionGroup group) {
        return new ItemProjectorConfigPanel(ItemProjector.formatPointLocation(player, location, RELATIVE_PANEL_LOCATION), group.getId(), (float)TransformationUtils.yawToCardinalDirection(player.getEyeLocation().getYaw()));
    }

    @Override
    public ConfigPanel getPanel(ConfigPanelId panelId, ConnectionGroupId groupId) {
        return new ItemProjectorConfigPanel(panelId, groupId);
    }

    @NotNull
    private static Matrix4f calculateItemTransformation(double size, double offset) {
        return new TransformationMatrixBuilder().translate(new Vector3f((Vector3fc)ITEM_DISPLAY_ADDITIONAL_OFFSET).add((Vector3fc)new Vector3f(0.0f, (float)offset, 0.0f))).scale(new Vector3f((Vector3fc)ITEM_DISPLAY_ADDITIONAL_SIZE).add((Vector3fc)new Vector3f((float)size))).buildForItemDisplay();
    }

    public static void onConfigUpdated(Location location) {
        Display display;
        Optional<Display> display2 = ItemProjector.getDisplay(location, "item");
        if (display2.isEmpty() || !((display = display2.get()) instanceof ItemDisplay)) {
            return;
        }
        ItemDisplay itemDisplay = (ItemDisplay)display;
        itemDisplay.setBillboard(Display.Billboard.values()[BlockStorageAPI.getInt(location, "QP_MODE")]);
        itemDisplay.setTransformationMatrix(ItemProjector.calculateItemTransformation(BlockStorageAPI.getDouble(location, "QP_SIZE") * 0.1, BlockStorageAPI.getDouble(location, "QP_HEIGHT") * 0.1));
    }
}

