/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.base;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Vector3f;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.transformations.TransformationUtils;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.base.QuapticBlock;
import org.metamechanists.quaptics.implementation.burnout.BurnoutManager;
import org.metamechanists.quaptics.implementation.burnout.BurnoutRunnable;
import org.metamechanists.quaptics.panels.info.InfoPanel;
import org.metamechanists.quaptics.storage.QuapticStorage;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;
import org.metamechanists.quaptics.utils.id.simple.DisplayGroupId;

public abstract class ConnectedBlock
extends QuapticBlock {
    protected ConnectedBlock(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    protected abstract float getConnectionRadius();

    protected abstract List<ConnectionPoint> initConnectionPoints(ConnectionGroupId var1, Player var2, Location var3);

    protected boolean isTicker() {
        return false;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onPlace(@NotNull BlockPlaceEvent event) {
        Location location = event.getBlock().getLocation();
        Optional<DisplayGroupId> displayGroupId = ConnectedBlock.getDisplayGroupId(location);
        if (displayGroupId.isEmpty()) {
            return;
        }
        ConnectionGroupId groupId = new ConnectionGroupId(displayGroupId.get());
        List<ConnectionPoint> points = this.initConnectionPoints(groupId, event.getPlayer(), location);
        new ConnectionGroup(groupId, this, points, this.isTicker());
        QuapticStorage.addGroup(groupId);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onBreak(@NotNull Location location) {
        ConnectedBlock.getGroup(location).ifPresent(ConnectionGroup::remove);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected boolean onShiftRightClick(@NotNull Location location, @NotNull Player player) {
        Optional<ConnectionGroup> group = ConnectedBlock.getGroup(location);
        if (group.isEmpty()) {
            return true;
        }
        boolean isAnyPanelHidden = group.get().getPointPanels().stream().anyMatch(InfoPanel::isPanelHidden);
        group.get().getPointPanels().forEach(panel -> panel.setPanelHidden(!isAnyPanelHidden));
        return true;
    }

    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
    }

    public void onTick2(@NotNull ConnectionGroup group, @NotNull Location location) {
    }

    public void onTick6(@NotNull ConnectionGroup group, @NotNull Location location) {
    }

    protected void onTick10(@NotNull ConnectionGroup group, @NotNull Location location) {
    }

    public void onTick22(@NotNull ConnectionGroup group, @NotNull Location location) {
    }

    public void onTick102(@NotNull ConnectionGroup group, @NotNull Location location) {
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onSlimefunTick(@NotNull Block block, SlimefunItem item, Config data) {
        Optional<ConnectionGroup> groupOptional = ConnectedBlock.getGroup(block.getLocation());
        groupOptional.ifPresent(connectionGroup -> this.onTick10((ConnectionGroup)connectionGroup, block.getLocation()));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void burnout(Location location) {
        this.onBreak(location);
        ConnectedBlock.getGroup(location).ifPresent(ConnectionGroup::remove);
        super.burnout(location);
    }

    private boolean doBurnoutCheck(@NotNull ConnectionGroup group, @NotNull ConnectionPoint point) {
        if (point.getLink().isEmpty() || point.getLink().get().getPower() <= this.settings.getTier().maxPower) {
            return false;
        }
        group.getLocation().ifPresent(location -> {
            if (!BlockStorageAPI.hasData(location, "QP_BURNOUT")) {
                BlockStorageAPI.set(location, "QP_BURNOUT", true);
                BurnoutManager.addBurnout(new BurnoutRunnable((Location)location));
            }
        });
        return true;
    }

    protected boolean doBurnoutCheck(@NotNull ConnectionGroup group, @NotNull String pointName) {
        Optional<ConnectionPoint> point = group.getPoint(pointName);
        return point.isPresent() && this.doBurnoutCheck(group, point.get());
    }

    protected boolean doBurnoutCheck(@NotNull ConnectionGroup group, @NotNull List<? extends ConnectionPoint> points) {
        return points.stream().anyMatch(input -> this.doBurnoutCheck(group, (ConnectionPoint)input));
    }

    @NotNull
    private static List<ConnectionPoint> getLinkedPoints(Location location) {
        Optional<ConnectionGroup> group = ConnectedBlock.getGroup(location);
        if (group.isEmpty()) {
            return new ArrayList<ConnectionPoint>();
        }
        return group.get().getPointList().stream().filter(point -> point.getLink().isPresent()).toList();
    }

    @NotNull
    private static List<ConnectionPoint> getLinkedOutputs(Location location) {
        return ConnectedBlock.getLinkedPoints(location).stream().filter(ConnectionPoint::isOutput).toList();
    }

    @NotNull
    private static List<ConnectionPoint> getLinkedInputs(Location location) {
        return ConnectedBlock.getLinkedPoints(location).stream().filter(ConnectionPoint::isInput).toList();
    }

    @NotNull
    protected static List<ConnectionPoint> getEnabledInputs(Location location) {
        return ConnectedBlock.getLinkedInputs(location).stream().filter(ConnectionPoint::isLinkEnabled).toList();
    }

    @NotNull
    protected static @Unmodifiable List<Link> getOutgoingLinks(Location location) {
        return ConnectedBlock.getLinkedOutputs(location).stream().map(output -> output.getLink().get()).toList();
    }

    @NotNull
    protected static @Unmodifiable List<Link> getIncomingLinks(Location location) {
        return ConnectedBlock.getLinkedInputs(location).stream().map(output -> output.getLink().get()).toList();
    }

    protected static Optional<Link> getLink(Location location, String name) {
        Optional<ConnectionGroup> group = ConnectedBlock.getGroup(location);
        if (group.isEmpty()) {
            return Optional.empty();
        }
        Optional<ConnectionPoint> point = group.get().getPoint(name);
        if (point.isEmpty()) {
            return Optional.empty();
        }
        return point.get().getLink();
    }

    protected static Optional<Link> getLink(@NotNull ConnectionGroup group, String name) {
        Optional<Location> location = group.getLocation();
        return location.isEmpty() ? Optional.empty() : ConnectedBlock.getLink(location.get(), name);
    }

    private Optional<Location> calculatePointLocationSphere(@NotNull ConnectionPointId from, @NotNull ConnectionPointId to) {
        Object fromPoint = from.get();
        Object toPoint = to.get();
        if (((Optional)fromPoint).isEmpty() || ((Optional)toPoint).isEmpty()) {
            return Optional.empty();
        }
        Optional<ConnectionGroup> fromGroup = ((ConnectionPoint)((Optional)fromPoint).get()).getGroup();
        Optional<ConnectionGroup> toGroup = ((ConnectionPoint)((Optional)toPoint).get()).getGroup();
        if (fromGroup.isEmpty() || toGroup.isEmpty()) {
            return Optional.empty();
        }
        Optional<Location> fromLocation = fromGroup.get().getLocation();
        Optional<Location> toLocation = toGroup.get().getLocation();
        if (fromLocation.isEmpty() || toLocation.isEmpty()) {
            return Optional.empty();
        }
        Vector radiusDirection = Vector.fromJOML((Vector3f)TransformationUtils.getDirection(fromLocation.get(), toLocation.get()).mul(this.getConnectionRadius()));
        return Optional.of(fromLocation.get().clone().toCenterLocation().add(radiusDirection));
    }

    public void connect(@NotNull ConnectionPointId from, @NotNull ConnectionPointId to) {
        this.calculatePointLocationSphere(from, to).ifPresent(location -> ConnectedBlock.changePointLocation(from, location));
    }

    private static void changePointLocation(@NotNull ConnectionPointId pointId, @NotNull Location newLocation) {
        ((Optional)pointId.get()).ifPresent(point -> point.changeLocation(newLocation));
    }

    public static Optional<ConnectionGroup> getGroup(Location location) {
        Optional<DisplayGroupId> displayGroupId = ConnectedBlock.getDisplayGroupId(location);
        return displayGroupId.isEmpty() ? Optional.empty() : new ConnectionGroupId(displayGroupId.get()).get();
    }
}

