/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.attachments;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.panels.config.ConfigPanel;
import org.metamechanists.quaptics.panels.config.ConfigPanelContainer;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public interface ConfigPanelBlock {
    public static Optional<ConfigPanelId> getPanelId(Location location) {
        return BlockStorageAPI.getConfigPanelId(location, "QP_PANEL_ID");
    }

    public static void setPanelId(Location location, @NotNull ConfigPanelId id) {
        BlockStorageAPI.set(location, "QP_PANEL_ID", id);
    }

    default public void interact(@NotNull ConnectionGroup group, String name, String type) {
        Optional<Location> location = group.getLocation();
        if (location.isEmpty()) {
            return;
        }
        Optional<ConfigPanelId> panelId = ConfigPanelBlock.getPanelId(location.get());
        if (panelId.isEmpty()) {
            return;
        }
        ConfigPanel panel = this.getPanel(panelId.get(), group.getId());
        panel.interact(location.get(), name, type);
    }

    default public void onPlaceConfigPanelBlock(@NotNull BlockPlaceEvent event) {
        Location location = event.getBlock().getLocation();
        Optional<ConnectionGroup> group = ConnectedBlock.getGroup(location);
        group.ifPresent(connectionGroup -> ConfigPanelBlock.setPanelId(location, this.createPanel(location, event.getPlayer(), (ConnectionGroup)connectionGroup).getId()));
    }

    default public void onBreakConfigPanelBlock(@NotNull Location location) {
        Optional<ConfigPanelId> panelId = ConfigPanelBlock.getPanelId(location);
        Optional<ConfigPanelContainer> panel = panelId.isPresent() ? panelId.get().get() : Optional.empty();
        panel.ifPresent(ConfigPanelContainer::remove);
    }

    public ConfigPanel createPanel(Location var1, Player var2, @NotNull ConnectionGroup var3);

    public ConfigPanel getPanel(ConfigPanelId var1, ConnectionGroupId var2);
}

