/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.displaymodellib.transformations;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class TransformationUtils {
    private static final List<BlockFace> AXIS = new ArrayList<BlockFace>(List.of(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST));

    public static double yawToCardinalDirection(float yaw) {
        return (double)(-Math.round(yaw / 90.0f)) * 1.5707963267948966;
    }

    @NotNull
    public static BlockFace yawToFace(float yaw) {
        return AXIS.get(Math.round(yaw / 90.0f) & 3);
    }

    public static Vector3f rotatedRadius(float radius, float x, float y, float z) {
        return new Vector3f(0.0f, 0.0f, radius).rotateX(x).rotateY(y).rotateZ(z);
    }

    public static Vector3f rotatedRadius(float radius, double y) {
        return new Vector3f(0.0f, 0.0f, radius).rotateY((float)y);
    }

    @NotNull
    public static Vector3f getDisplacement(Location from, @NotNull Location to) {
        return to.clone().subtract(from).toVector().toVector3f();
    }

    @NotNull
    public static Vector3f getDisplacement(Vector3f from, @NotNull Vector3f to) {
        return new Vector3f((Vector3fc)to).sub((Vector3fc)from);
    }

    @NotNull
    public static Vector3f getDirection(@NotNull Location from, @NotNull Location to) {
        return TransformationUtils.getDisplacement(from, to).normalize();
    }

    @NotNull
    public static Vector3f getDirection(@NotNull Vector3f from, @NotNull Vector3f to) {
        return TransformationUtils.getDisplacement(from, to).normalize();
    }

    @NotNull
    public static Location getMidpoint(@NotNull Location from, @NotNull Location to) {
        return from.clone().add(to).multiply(0.5);
    }

    @NotNull
    public static Vector3f getMidpoint(@NotNull Vector3f from, @NotNull Vector3f to) {
        return new Vector3f((Vector3fc)from).add((Vector3fc)to).mul(0.5f);
    }

    private TransformationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

