/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.displaymodellib.sefilib.entity;

import io.github.bakedlibs.dough.versions.SemanticVersion;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.LivingEntityCategory;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.LivingEntityDefinition;
import org.metamechanists.quaptics.displaymodellib.sefilib.version.Versions;

public class LivingEntitySelector {
    private final Set<LivingEntityCategory> categoryInclusions = new HashSet<LivingEntityCategory>();
    private final Set<LivingEntityCategory> categoryExclusions = new HashSet<LivingEntityCategory>();
    private final Set<LivingEntityDefinition> typeInclusions = new HashSet<LivingEntityDefinition>();
    private final Set<LivingEntityDefinition> typeExclusions = new HashSet<LivingEntityDefinition>();
    private SemanticVersion version = Versions.VERSION_EARLIEST;

    public LivingEntitySelector includeCategories(LivingEntityCategory ... categories) {
        Collections.addAll(this.categoryInclusions, categories);
        return this;
    }

    public LivingEntitySelector excludeCategories(LivingEntityCategory ... categories) {
        Collections.addAll(this.categoryExclusions, categories);
        return this;
    }

    public LivingEntitySelector includeTypes(LivingEntityDefinition ... categories) {
        Collections.addAll(this.typeInclusions, categories);
        return this;
    }

    public LivingEntitySelector excludeTypes(LivingEntityDefinition ... categories) {
        Collections.addAll(this.typeExclusions, categories);
        return this;
    }

    public LivingEntitySelector setVersion(SemanticVersion version) {
        this.version = version;
        return this;
    }

    public Set<LivingEntityDefinition> process(MatchType matchType) {
        HashSet<LivingEntityDefinition> livingEntityDefinitions = new HashSet<LivingEntityDefinition>();
        if (!this.categoryInclusions.isEmpty()) {
            this.addCatInclusions(livingEntityDefinitions, matchType);
        }
        if (!this.categoryExclusions.isEmpty()) {
            this.removeCatExclusions(livingEntityDefinitions, matchType);
        }
        if (!this.typeInclusions.isEmpty()) {
            livingEntityDefinitions.addAll(this.typeInclusions);
        }
        if (!this.typeExclusions.isEmpty()) {
            livingEntityDefinitions.removeAll(this.typeExclusions);
        }
        return livingEntityDefinitions;
    }

    private void addCatInclusions(Set<LivingEntityDefinition> set, MatchType matchType) {
        block4: {
            block3: {
                if (matchType != MatchType.MATCH_ANY) break block3;
                for (LivingEntityCategory category : this.categoryInclusions) {
                    for (LivingEntityDefinition definition : LivingEntityDefinition.getValues()) {
                        if (!definition.isCategorized(category) || !definition.existsIn(this.version)) continue;
                        set.add(definition);
                    }
                }
                break block4;
            }
            if (matchType != MatchType.MATCH_ALL) break block4;
            for (LivingEntityDefinition definition : LivingEntityDefinition.getValues()) {
                if (!definition.isCategorized(this.categoryInclusions) || !definition.existsIn(this.version)) continue;
                set.add(definition);
            }
        }
    }

    private void removeCatExclusions(Set<LivingEntityDefinition> set, MatchType matchType) {
        if (matchType == MatchType.MATCH_ANY) {
            for (LivingEntityCategory category : this.categoryExclusions) {
                set.removeIf(definition -> definition.isCategorized(category) && definition.existsIn(this.version));
            }
        } else if (matchType == MatchType.MATCH_ALL) {
            set.removeIf(definition -> definition.isCategorized(this.categoryExclusions) && definition.existsIn(this.version));
        }
    }

    public static LivingEntitySelector start() {
        return new LivingEntitySelector();
    }

    public static enum MatchType {
        MATCH_ALL,
        MATCH_ANY;

    }
}

