/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.beams.beam;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.beams.DeprecatedBeamStorage;
import org.metamechanists.quaptics.beams.beam.Beam;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelLine;
import org.metamechanists.quaptics.displaymodellib.transformations.TransformationUtils;
import org.metamechanists.quaptics.utils.id.complex.DirectBeamId;
import org.metamechanists.quaptics.utils.id.simple.BlockDisplayId;

public class DirectBeam
implements Beam {
    private final BlockDisplayId displayId;

    public DirectBeam(Material material, @NotNull Location source, Location target, float thickness, double roll) {
        Location midpoint = TransformationUtils.getMidpoint(source, target);
        this.displayId = new BlockDisplayId(new ModelLine().from(TransformationUtils.getDisplacement(midpoint, source)).to(TransformationUtils.getDisplacement(midpoint, target)).thickness(thickness).roll(roll).brightness(15).material(material).build(midpoint).getUniqueId());
    }

    public DirectBeam(@NotNull DirectBeamId id) {
        this.displayId = new BlockDisplayId(id);
    }

    public DirectBeamId getId() {
        return new DirectBeamId(this.displayId);
    }

    private Optional<BlockDisplay> getDisplay() {
        return this.displayId.get();
    }

    @Override
    public void tick() {
    }

    public void deprecate() {
        DeprecatedBeamStorage.deprecate(this);
    }

    @Override
    public void remove() {
        this.getDisplay().ifPresent(Entity::remove);
    }

    @Override
    public boolean expired() {
        return true;
    }

    public void setMaterial(Material material) {
        this.getDisplay().ifPresent(display -> display.setBlock(material.createBlockData()));
    }

    public void setThicknessAndRoll(@NotNull Location source, Location target, float thickness, double roll) {
        Location midpoint = TransformationUtils.getMidpoint(source, target);
        this.getDisplay().ifPresent(display -> display.setTransformationMatrix(new ModelLine().from(TransformationUtils.getDisplacement(midpoint, source)).to(TransformationUtils.getDisplacement(midpoint, target)).thickness(thickness).roll(roll).getMatrix()));
    }
}

