/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.utils;

import java.util.stream.IntStream;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.metamechanists.quaptics.displaymodellib.transformations.TransformationUtils;

public final class Particles {
    public static void animatedLine(Particle particle, @NotNull Location from, @NotNull Location to, int particleCount, double offset, double speed) {
        Vector3f direction = TransformationUtils.getDirection(from, to);
        double distance = from.distance(to);
        float spacing = (float)((double)(1.0f / (float)(particleCount - 1)) * distance);
        Location currentLocation = from.clone().add(Vector.fromJOML((Vector3f)new Vector3f((Vector3fc)direction).mul((float)(offset * (double)spacing))));
        Vector locationIncrement = Vector.fromJOML((Vector3f)new Vector3f((Vector3fc)direction).mul(spacing));
        IntStream.range(0, particleCount - 1).forEach(i -> {
            from.getWorld().spawnParticle(particle, currentLocation, 1, 0.0, 0.0, 0.0, speed);
            currentLocation.add(locationIncrement);
        });
    }

    public static void animatedHorizontalCircle(Particle particle, @NotNull Location center, double radius, int particleCount, double offset, double speed) {
        Vector relativeLocation = new Vector(0.0, 0.0, radius);
        relativeLocation.rotateAroundY(Math.PI * 2 / (double)particleCount * offset);
        IntStream.range(0, particleCount).forEach(i -> {
            center.getWorld().spawnParticle(particle, center.clone().add(relativeLocation), 1, 0.0, 0.0, 0.0, speed);
            relativeLocation.rotateAroundY(Math.PI * 2 / (double)particleCount);
        });
    }

    private Particles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

