/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.info;

import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.displaymodellib.builders.InteractionBuilder;
import org.metamechanists.quaptics.panels.info.InfoPanelAttribute;
import org.metamechanists.quaptics.storage.PersistentDataTraverser;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelAttributeId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;
import org.metamechanists.quaptics.utils.id.simple.InteractionId;

public class InfoPanelContainer {
    private final InfoPanelId id;
    private boolean hidden = true;
    private final Vector spacing;
    private final Map<String, ? extends InfoPanelAttributeId> attributes;

    public InfoPanelContainer(Location location, Vector spacing, Map<String, ? extends InfoPanelAttributeId> attributes) {
        this.id = new InfoPanelId(new InteractionBuilder().height(0.0f).width(0.0f).build(location).getUniqueId());
        this.spacing = spacing;
        this.attributes = attributes;
        this.saveData();
    }

    public InfoPanelContainer(@NotNull InfoPanelId panelId) {
        PersistentDataTraverser traverser = new PersistentDataTraverser(panelId);
        this.id = panelId;
        this.hidden = traverser.getBoolean("hidden");
        this.spacing = traverser.getVector("spacing");
        this.attributes = traverser.getInfoPanelAttributeIdMap("attributes");
    }

    private void saveData() {
        PersistentDataTraverser traverser = new PersistentDataTraverser(this.id);
        traverser.set("hidden", this.hidden);
        traverser.set("spacing", this.spacing);
        traverser.set("attributes", this.attributes);
    }

    private Optional<Interaction> getInteraction() {
        return new InteractionId(this.id).get();
    }

    private Optional<InfoPanelAttribute> getAttribute(String name) {
        return this.attributes.get(name).get();
    }

    public void setAttributeHidden(String name, boolean attributeHidden) {
        this.getAttribute(name).ifPresent(attribute -> {
            attribute.setHidden(attributeHidden);
            attribute.updateVisibility(this.hidden);
        });
        this.reorderAttributes();
    }

    public void changeLocation(Location location) {
        this.getInteraction().ifPresent(displayGroup -> displayGroup.teleport(location));
        this.attributes.values().forEach(attributeId -> ((Optional)attributeId.get()).ifPresent(attribute -> attribute.changeLocation(location)));
        this.reorderAttributes();
    }

    public void setText(String name, String text) {
        this.getAttribute(name).ifPresent(attribute -> attribute.setText(text));
    }

    public void setHidden(boolean hidden) {
        if (this.hidden != hidden) {
            this.hidden = hidden;
            this.updateAttributeVisibility();
            this.saveData();
        }
    }

    public void toggleHidden() {
        this.setHidden(!this.hidden);
    }

    private void updateAttributeVisibility() {
        this.reorderAttributes();
        this.attributes.values().stream().map(InfoPanelAttributeId::get).filter(Optional::isPresent).forEach(attributeOptional -> attributeOptional.ifPresent(attribute -> attribute.updateVisibility(this.hidden)));
    }

    private void removeAttributes() {
        this.attributes.values().stream().map(InfoPanelAttributeId::get).filter(Optional::isPresent).map(Optional::get).forEach(InfoPanelAttribute::remove);
    }

    private void reorderAttributes() {
        Optional<Interaction> interaction = this.getInteraction();
        if (interaction.isEmpty()) {
            return;
        }
        Location location = interaction.get().getLocation().clone();
        this.attributes.values().stream().map(InfoPanelAttributeId::get).filter(Optional::isPresent).map(Optional::get).filter(InfoPanelAttribute::isVisible).forEach(attribute -> {
            attribute.changeLocation(location);
            location.subtract(this.spacing);
        });
    }

    public void remove() {
        this.removeAttributes();
        this.getInteraction().ifPresent(Entity::remove);
    }

    public InfoPanelId getId() {
        return this.id;
    }

    public boolean isHidden() {
        return this.hidden;
    }
}

