/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.config;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.panels.config.ConfigPanelContainer;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public abstract class ConfigPanel {
    protected static final float SIZE = 0.3f;
    protected final ConfigPanelContainer container;
    private final ConnectionGroupId groupId;

    protected ConfigPanel(ConnectionGroupId groupId, @NotNull Location location, float rotationY) {
        this.groupId = groupId;
        this.container = this.buildPanelContainer(groupId, location, rotationY);
        this.setPanelHidden(false);
    }

    protected ConfigPanel(@NotNull ConfigPanelId id, ConnectionGroupId groupId) {
        this.container = (ConfigPanelContainer)((Optional)id.get()).get();
        this.groupId = groupId;
    }

    public ConfigPanelId getId() {
        return this.container.getId();
    }

    protected Optional<ConnectionGroup> getGroup() {
        return this.groupId.get();
    }

    private void setPanelHidden(boolean hidden) {
        this.container.setHidden(hidden);
        this.update();
    }

    protected boolean isPanelHidden() {
        return this.container.isHidden();
    }

    protected abstract Vector getOffset();

    protected abstract ConfigPanelContainer buildPanelContainer(@NotNull ConnectionGroupId var1, @NotNull Location var2, float var3);

    public abstract void interact(@NotNull Location var1, String var2, String var3);

    protected abstract void update();
}

