/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.multiblocks.reactor;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Map;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelDiamond;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.ComplexMultiblock;
import org.metamechanists.quaptics.implementation.attachments.InfoPanelBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.implementation.multiblocks.reactor.ReactorRing;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.panels.info.BlockInfoPanel;
import org.metamechanists.quaptics.panels.info.implementation.ReactorInfoPanel;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Particles;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;

public class ReactorController
extends ConnectedBlock
implements ComplexMultiblock,
InfoPanelBlock {
    private static final Vector RING_1_LOCATION = new Vector(3, 0, 0);
    private static final Vector RING_2_LOCATION = new Vector(2, 0, 2);
    private static final Vector RING_3_LOCATION = new Vector(0, 0, 3);
    private static final Vector RING_4_LOCATION = new Vector(-2, 0, 2);
    private static final Vector RING_5_LOCATION = new Vector(-3, 0, 0);
    private static final Vector RING_6_LOCATION = new Vector(-2, 0, -2);
    private static final Vector RING_7_LOCATION = new Vector(0, 0, -3);
    private static final Vector RING_8_LOCATION = new Vector(2, 0, -2);
    private static final List<Vector> RING_LOCATIONS = List.of(RING_1_LOCATION, RING_2_LOCATION, RING_3_LOCATION, RING_4_LOCATION, RING_5_LOCATION, RING_6_LOCATION, RING_7_LOCATION, RING_8_LOCATION);
    public static final Settings REACTOR_CONTROLLER_SETTINGS = Settings.builder().tier(Tier.ADVANCED).operatingPowerHidden(true).powerThreshold(1800.0).powerMultiplier(1.75).maxOutputPower(1.75 * Tier.INTERMEDIATE.maxPower * (double)RING_LOCATIONS.size()).timeToMaxEfficiency(600).build();
    public static final SlimefunItemStack REACTOR_CONTROLLER = new SlimefunItemStack("QP_REACTOR_CONTROLLER", Material.CYAN_CONCRETE, "&6Reactor Controller", Lore.create(REACTOR_CONTROLLER_SETTINGS, Lore.multiblock(), "&7\u25cf Generates more power than you put in", "&7\u25cf Takes some time to reach maximum efficiency"));
    private static final double MAX_ANIMATION_STEP = (double)0.2f;
    private final Vector outputPoint1Location = new Vector(this.getConnectionRadius(), 0.0f, 0.0f);
    private final Vector outputPoint2Location = new Vector(-this.getConnectionRadius(), 0.0f, 0.0f);
    private final Vector outputPoint3Location = new Vector(0.0f, 0.0f, this.getConnectionRadius());
    private final Vector outputPoint4Location = new Vector(0.0f, 0.0f, -this.getConnectionRadius());

    public ReactorController(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.7f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("main", new ModelDiamond().material(Material.LIGHT_GRAY_CONCRETE).size(1.0f)).add("panel1", new ModelCuboid().material(Material.CYAN_CONCRETE).size(0.8f, 0.6f, 0.6f).rotation(ModelDiamond.ROTATION)).add("panel2", new ModelCuboid().material(Material.CYAN_CONCRETE).size(0.6f, 0.8f, 0.6f).rotation(ModelDiamond.ROTATION)).add("panel3", new ModelCuboid().material(Material.CYAN_CONCRETE).size(0.6f, 0.6f, 0.8f).rotation(ModelDiamond.ROTATION)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output 1", location.clone().toCenterLocation().add(this.outputPoint1Location)), new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output 2", location.clone().toCenterLocation().add(this.outputPoint2Location)), new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output 3", location.clone().toCenterLocation().add(this.outputPoint3Location)), new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output 4", location.clone().toCenterLocation().add(this.outputPoint4Location)));
    }

    @Override
    protected void initBlockStorage(@NotNull Location location) {
        BlockStorageAPI.set(location, "QP_TIME_SINCE_REACTOR_STARTED", 0.0);
        BlockStorageAPI.set(location, "QP_OUTPUT_POWER", 0.0);
        BlockStorageAPI.set(location, "QP_ANIMATION_OFFSET", 0.0);
    }

    @Override
    protected boolean isTicker() {
        return true;
    }

    @Override
    public BlockInfoPanel createPanel(Location location, @NotNull ConnectionGroup group) {
        return new ReactorInfoPanel(location, group.getId());
    }

    @Override
    public BlockInfoPanel getPanel(InfoPanelId panelId, ConnectionGroupId groupId) {
        return new ReactorInfoPanel(panelId, groupId);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onPlace(@NotNull BlockPlaceEvent event) {
        super.onPlace(event);
        this.onPlaceInfoPanelBlock(event);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onBreak(@NotNull Location location) {
        super.onBreak(location);
        this.onBreakInfoPanelBlock(location);
    }

    @Override
    protected boolean onRightClick(@NotNull Location location, @NotNull Player player) {
        this.multiblockInteract(location.getBlock(), player);
        return true;
    }

    @Override
    public void onTick22(@NotNull ConnectionGroup group, @NotNull Location location) {
        boolean isStructureValid = this.isStructureValid(location.getBlock());
        BlockStorageAPI.set(location, "QP_MULTIBLOCK_INTACT", isStructureValid);
        this.setPanelHidden(group, !isStructureValid);
        this.updatePanel(group);
    }

    @Override
    public void onTick10(@NotNull ConnectionGroup group, @NotNull Location location) {
        double inputPower = ReactorController.getTotalInputPower(location);
        BlockStorageAPI.set(location, "QP_INPUT_POWER", inputPower);
        boolean isStructureValid = BlockStorageAPI.getBoolean(location, "QP_MULTIBLOCK_INTACT");
        if (!isStructureValid || inputPower < this.settings.getPowerThreshold()) {
            BlockStorageAPI.set(location, "QP_TIME_SINCE_REACTOR_STARTED", 0.0);
            BlockStorageAPI.set(location, "QP_OUTPUT_POWER", 0.0);
            BlockStorageAPI.set(location, "QP_POWERED", false);
            return;
        }
        BlockStorageAPI.set(location, "QP_POWERED", true);
        this.updatePanel(group);
    }

    @Override
    public void onTick2(@NotNull ConnectionGroup group, @NotNull Location location) {
        List<Link> outgoingLinks = ReactorController.getOutgoingLinks(location);
        if (!BlockStorageAPI.getBoolean(location, "QP_POWERED")) {
            outgoingLinks.forEach(link -> link.setPower(0.0));
            return;
        }
        double secondsSinceReactorStarted = BlockStorageAPI.getDouble(location, "QP_TIME_SINCE_REACTOR_STARTED");
        BlockStorageAPI.set(location, "QP_TIME_SINCE_REACTOR_STARTED", secondsSinceReactorStarted += 0.1);
        double inputPower = BlockStorageAPI.getDouble(location, "QP_INPUT_POWER");
        double powerProportion = Math.min(secondsSinceReactorStarted, (double)this.settings.getTimeToMaxEfficiency()) / (double)this.settings.getTimeToMaxEfficiency();
        double outputPower = powerProportion * inputPower * this.settings.getPowerMultiplier();
        BlockStorageAPI.set(location, "QP_OUTPUT_POWER", outputPower);
        this.tickAnimation(location, secondsSinceReactorStarted);
        outgoingLinks.forEach(link -> link.setPower(outputPower / (double)outgoingLinks.size()));
    }

    @Override
    public Map<Vector, ItemStack> getStructure() {
        return Map.of(RING_1_LOCATION, ReactorRing.REACTOR_RING, RING_2_LOCATION, ReactorRing.REACTOR_RING, RING_3_LOCATION, ReactorRing.REACTOR_RING, RING_4_LOCATION, ReactorRing.REACTOR_RING, RING_5_LOCATION, ReactorRing.REACTOR_RING, RING_6_LOCATION, ReactorRing.REACTOR_RING, RING_7_LOCATION, ReactorRing.REACTOR_RING, RING_8_LOCATION, ReactorRing.REACTOR_RING);
    }

    @Override
    public void tickAnimation(@NotNull Location centerLocation, double timeSeconds) {
        double outputPower = BlockStorageAPI.getDouble(centerLocation, "QP_OUTPUT_POWER");
        double animationOffset = BlockStorageAPI.getDouble(centerLocation, "QP_ANIMATION_OFFSET") + outputPower / this.getMaxOutputPower() * (double)0.2f;
        BlockStorageAPI.set(centerLocation, "QP_ANIMATION_OFFSET", animationOffset);
        Particles.animatedHorizontalCircle(Particle.ELECTRIC_SPARK, centerLocation.clone().toCenterLocation(), 3.0, 3, animationOffset, 0.0);
    }

    public double getMaxOutputPower() {
        return ReactorRing.REACTOR_RING_SETTINGS.getTier().maxPower * (double)RING_LOCATIONS.size() * this.settings.getPowerMultiplier();
    }

    private static double getRingInputPower(@NotNull Location ringLocation) {
        return BlockStorageAPI.getDouble(ringLocation, "QP_INPUT_POWER");
    }

    public static double getTotalInputPower(@NotNull Location location) {
        return RING_LOCATIONS.stream().mapToDouble(vector -> ReactorController.getRingInputPower(location.clone().add(vector))).sum();
    }
}

