/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.multiblocks.beacons.components;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class BeaconPowerSupply
extends ConnectedBlock {
    public static final Settings BEACON_POWER_SUPPLY_1_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).operatingPowerHidden(true).build();
    public static final Settings BEACON_POWER_SUPPLY_2_SETTINGS = Settings.builder().tier(Tier.ADVANCED).operatingPowerHidden(true).build();
    public static final SlimefunItemStack BEACON_POWER_SUPPLY_1 = new SlimefunItemStack("QP_BEACON_POWER_SUPPLY_1", Material.GRAY_CONCRETE, "&dBeacon Power Supply &5I", Lore.create(BEACON_POWER_SUPPLY_1_SETTINGS, Lore.multiblockComponent()));
    public static final SlimefunItemStack BEACON_POWER_SUPPLY_2 = new SlimefunItemStack("QP_BEACON_POWER_SUPPLY_2", Material.GRAY_CONCRETE, "&dBeacon Power Supply &5II", Lore.create(BEACON_POWER_SUPPLY_2_SETTINGS, Lore.multiblockComponent()));

    public BeaconPowerSupply(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 1.0f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("main", new ModelCuboid().material(Material.GRAY_CONCRETE).size(1.1f, 1.0f, 1.1f).rotation(0.7853981633974483)).add("panel1", new ModelCuboid().material(this.settings.getTier().concreteMaterial).size(0.8f, 0.7f, 1.2f).rotation(0.7853981633974483)).add("panel2", new ModelCuboid().material(this.settings.getTier().concreteMaterial).size(1.2f, 0.7f, 0.8f).rotation(0.7853981633974483)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", location.clone().toCenterLocation().add(new Vector(0.0f, 0.0f, -this.getConnectionRadius()))));
    }

    @Override
    protected void initBlockStorage(@NotNull Location location) {
        BlockStorageAPI.set(location, "QP_INPUT_POWER", 0.0);
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (this.doBurnoutCheck(group, "input")) {
            return;
        }
        Optional<Link> link = BeaconPowerSupply.getLink(location, "input");
        if (link.isEmpty()) {
            return;
        }
        double power = link.get().getPower();
        double frequency = link.get().getFrequency();
        BlockStorageAPI.set(location, "QP_POWER", power);
        BlockStorageAPI.set(location, "QP_FREQUENCY", frequency);
    }
}

