/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.manipulators;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelDiamond;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerLossBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class Combiner
extends ConnectedBlock
implements PowerAnimatedBlock,
PowerLossBlock {
    public static final Settings COMBINER_1_SETTINGS = Settings.builder().tier(Tier.PRIMITIVE).powerLoss(0.2).connections(2).build();
    public static final Settings COMBINER_2_SETTINGS = Settings.builder().tier(Tier.BASIC).powerLoss(0.14).connections(3).build();
    public static final Settings COMBINER_3_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).powerLoss(0.08).connections(4).build();
    public static final Settings COMBINER_4_SETTINGS = Settings.builder().tier(Tier.ADVANCED).powerLoss(0.05).connections(5).build();
    public static final SlimefunItemStack COMBINER_1 = new SlimefunItemStack("QP_COMBINER_1", Material.GRAY_STAINED_GLASS, "&9Combiner &8I", Lore.create(COMBINER_1_SETTINGS, "&7\u25cf Combines multiple quaptic rays into one"));
    public static final SlimefunItemStack COMBINER_2 = new SlimefunItemStack("QP_COMBINER_2", Material.GRAY_STAINED_GLASS, "&9Combiner &8II", Lore.create(COMBINER_2_SETTINGS, "&7\u25cf Combines multiple quaptic rays into one"));
    public static final SlimefunItemStack COMBINER_3 = new SlimefunItemStack("QP_COMBINER_3", Material.GRAY_STAINED_GLASS, "&9Combiner &8III", Lore.create(COMBINER_3_SETTINGS, "&7\u25cf Combines multiple quaptic rays into one"));
    public static final SlimefunItemStack COMBINER_4 = new SlimefunItemStack("QP_COMBINER_4", Material.GRAY_STAINED_GLASS, "&9Combiner &8IV", Lore.create(COMBINER_4_SETTINGS, "&7\u25cf Combines multiple quaptic rays into one"));
    private static final double CONNECTION_ANGLE = 2.0943951023931953;
    private final Vector inputStartingLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());
    private final Vector outputLocation = new Vector(0.0f, 0.0f, this.getConnectionRadius());

    public Combiner(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.55f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("concrete", new ModelDiamond().material(this.settings.getTier().concreteMaterial).brightness(3).size(0.4f)).add("glass", new ModelDiamond().material(Material.GRAY_STAINED_GLASS).size(0.8f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        List<ConnectionPoint> points = IntStream.range(0, this.settings.getConnections()).mapToObj(i -> new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input " + Objects.toString(i), Combiner.formatPointLocation(player, location, this.getRelativeInputLocation(i)))).collect(Collectors.toList());
        points.add(new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output", Combiner.formatPointLocation(player, location, this.outputLocation)));
        return points;
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        List<ConnectionPoint> enabledInputs = Combiner.getEnabledInputs(location);
        if (this.doBurnoutCheck(group, enabledInputs)) {
            return;
        }
        this.onPoweredAnimation(location, !enabledInputs.isEmpty());
        List<Link> incomingLinks = Combiner.getIncomingLinks(location);
        Optional<Link> outputLink = Combiner.getLink(location, "output");
        if (outputLink.isEmpty()) {
            return;
        }
        double inputPower = incomingLinks.stream().mapToDouble(Link::getPower).sum();
        double inputFrequency = incomingLinks.stream().mapToDouble(Link::getFrequency).min().orElse(0.0);
        int inputPhase = incomingLinks.stream().mapToInt(Link::getPhase).min().orElse(0);
        outputLink.get().setPowerFrequencyPhase(PowerLossBlock.calculatePowerLoss(this.settings, inputPower), inputFrequency, inputPhase);
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "concrete", powered);
    }

    @NotNull
    private Vector getRelativeInputLocation(int i) {
        double angle = -1.0471975511965976 + 2.0943951023931953 * ((double)i / (double)(this.settings.getConnections() - 1));
        return this.inputStartingLocation.clone().rotateAroundY(angle);
    }
}

