/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.displaymodellib.sefilib.entity;

import com.google.common.collect.Sets;
import io.github.bakedlibs.dough.versions.SemanticVersion;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.entity.EntityType;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.LivingEntityCategory;
import org.metamechanists.quaptics.displaymodellib.sefilib.version.Versions;

public enum LivingEntityDefinition {
    ALLAY(Versions.VERSION_1_19, LivingEntityCategory.FLYING, LivingEntityCategory.PASSIVE, LivingEntityCategory.TAMEABLE),
    AXOLOTL(Versions.VERSION_1_17, LivingEntityCategory.ANIMAL, LivingEntityCategory.AQUATIC, LivingEntityCategory.BREEDABLE, LivingEntityCategory.PASSIVE),
    BAT(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.FLYING, LivingEntityCategory.PASSIVE),
    BEE(Versions.VERSION_1_15, LivingEntityCategory.ANIMAL, LivingEntityCategory.ARTHROPOD, LivingEntityCategory.BREEDABLE, LivingEntityCategory.FLYING, LivingEntityCategory.NEUTRAL),
    BLAZE(Versions.VERSION_1_14, LivingEntityCategory.FLYING, LivingEntityCategory.HOSTILE, LivingEntityCategory.NETHER),
    CAT(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.PASSIVE, LivingEntityCategory.TAMEABLE),
    CAVE_SPIDER(Versions.VERSION_1_14, LivingEntityCategory.ARTHROPOD, LivingEntityCategory.NEUTRAL),
    CHICKEN(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.FLYING, LivingEntityCategory.PASSIVE),
    COD(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.AQUATIC, LivingEntityCategory.FISH, LivingEntityCategory.PASSIVE),
    COW(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.PASSIVE),
    CREEPER(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE),
    DOLPHIN(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.AQUATIC, LivingEntityCategory.NEUTRAL),
    DONKEY(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.PASSIVE, LivingEntityCategory.RIDEABLE, LivingEntityCategory.TAMEABLE),
    DROWNED(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.UNDEAD),
    ELDER_GUARDIAN(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.AQUATIC, LivingEntityCategory.BOSS),
    ENDER_DRAGON(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.FLYING, LivingEntityCategory.END, LivingEntityCategory.BOSS),
    ENDERMAN(Versions.VERSION_1_14, LivingEntityCategory.NEUTRAL, LivingEntityCategory.END),
    ENDERMITE(Versions.VERSION_1_14, LivingEntityCategory.ARTHROPOD, LivingEntityCategory.HOSTILE),
    EVOKER(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.RAID, LivingEntityCategory.ILLAGER),
    FOX(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.PASSIVE, LivingEntityCategory.TAMEABLE),
    FROG(Versions.VERSION_1_19, LivingEntityCategory.ANIMAL, LivingEntityCategory.AQUATIC, LivingEntityCategory.BREEDABLE, LivingEntityCategory.PASSIVE),
    GHAST(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.FLYING, LivingEntityCategory.NETHER),
    GIANT(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.UNDEAD),
    GLOW_SQUID(Versions.VERSION_1_17, LivingEntityCategory.ANIMAL, LivingEntityCategory.AQUATIC, LivingEntityCategory.PASSIVE),
    GOAT(Versions.VERSION_1_17, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.NEUTRAL),
    GUARDIAN(Versions.VERSION_1_14, LivingEntityCategory.AQUATIC, LivingEntityCategory.HOSTILE),
    HOGLIN(Versions.VERSION_1_16, LivingEntityCategory.BREEDABLE, LivingEntityCategory.HOSTILE, LivingEntityCategory.NETHER, LivingEntityCategory.PIGLIN),
    HORSE(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.PASSIVE, LivingEntityCategory.RIDEABLE, LivingEntityCategory.TAMEABLE),
    HUSK(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.UNDEAD),
    ILLUSIONER(Versions.VERSION_1_14, LivingEntityCategory.ILLAGER),
    IRON_GOLEM(Versions.VERSION_1_14, LivingEntityCategory.GOLEM, LivingEntityCategory.NEUTRAL),
    LLAMA(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.NEUTRAL, LivingEntityCategory.TAMEABLE),
    MAGMA_CUBE(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.NETHER),
    MUSHROOM_COW(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.PASSIVE),
    MULE(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.PASSIVE, LivingEntityCategory.RIDEABLE, LivingEntityCategory.TAMEABLE),
    OCELOT(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.PASSIVE, LivingEntityCategory.TAMEABLE),
    PANDA(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.NEUTRAL),
    PARROT(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.FLYING, LivingEntityCategory.PASSIVE, LivingEntityCategory.TAMEABLE),
    PHANTOM(Versions.VERSION_1_14, LivingEntityCategory.FLYING, LivingEntityCategory.HOSTILE, LivingEntityCategory.UNDEAD),
    PIG(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.PASSIVE, LivingEntityCategory.RIDEABLE),
    PIGLIN(Versions.VERSION_1_16, LivingEntityCategory.NETHER, LivingEntityCategory.NEUTRAL, LivingEntityCategory.PIGLIN),
    PIGLIN_BRUTE(Versions.VERSION_1_16, LivingEntityCategory.HOSTILE, LivingEntityCategory.NETHER, LivingEntityCategory.PIGLIN),
    PILLAGER(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.RAID, LivingEntityCategory.ILLAGER),
    POLAR_BEAR(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.NEUTRAL),
    PUFFERFISH(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.AQUATIC, LivingEntityCategory.FISH, LivingEntityCategory.PASSIVE),
    RABBIT(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.PASSIVE),
    RAVAGER(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.RAID, LivingEntityCategory.ILLAGER),
    SALMON(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.AQUATIC, LivingEntityCategory.FISH, LivingEntityCategory.PASSIVE),
    SHEEP(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.PASSIVE),
    SHULKER(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.END),
    SILVERFISH(Versions.VERSION_1_14, LivingEntityCategory.ARTHROPOD, LivingEntityCategory.HOSTILE),
    SKELETON_HORSE(Versions.VERSION_1_14, LivingEntityCategory.PASSIVE, LivingEntityCategory.RIDEABLE, LivingEntityCategory.TAMEABLE, LivingEntityCategory.UNDEAD),
    SLIME(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE),
    SNOWMAN(Versions.VERSION_1_14, LivingEntityCategory.GOLEM, LivingEntityCategory.PASSIVE),
    SPIDER(Versions.VERSION_1_14, LivingEntityCategory.ARTHROPOD, LivingEntityCategory.NEUTRAL),
    SQUID(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.AQUATIC, LivingEntityCategory.PASSIVE),
    STRAY(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.UNDEAD),
    STRIDER(Versions.VERSION_1_16, LivingEntityCategory.BREEDABLE, LivingEntityCategory.NETHER, LivingEntityCategory.PASSIVE, LivingEntityCategory.RIDEABLE),
    TADPOLE(Versions.VERSION_1_19, LivingEntityCategory.ANIMAL, LivingEntityCategory.AQUATIC, LivingEntityCategory.PASSIVE),
    TRADER_LLAMA(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.TAMEABLE),
    TROPICAL_FISH(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.AQUATIC, LivingEntityCategory.FISH, LivingEntityCategory.PASSIVE),
    TURTLE(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.AQUATIC, LivingEntityCategory.BREEDABLE, LivingEntityCategory.PASSIVE),
    VEX(Versions.VERSION_1_14, LivingEntityCategory.FLYING, LivingEntityCategory.HOSTILE, LivingEntityCategory.ILLAGER),
    VILLAGER(Versions.VERSION_1_14, LivingEntityCategory.BREEDABLE, LivingEntityCategory.PASSIVE, LivingEntityCategory.TRADER, LivingEntityCategory.VILLAGER),
    VINDICATOR(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.RAID, LivingEntityCategory.ILLAGER),
    WANDERING_TRADER(Versions.VERSION_1_14, LivingEntityCategory.TRADER, LivingEntityCategory.VILLAGER, LivingEntityCategory.PASSIVE),
    WARDEN(Versions.VERSION_1_19, LivingEntityCategory.HOSTILE, LivingEntityCategory.BOSS),
    WITCH(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.RAID),
    WITHER(Versions.VERSION_1_14, LivingEntityCategory.BOSS, LivingEntityCategory.FLYING, LivingEntityCategory.HOSTILE, LivingEntityCategory.UNDEAD),
    WITHER_SKELETON(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.NETHER, LivingEntityCategory.UNDEAD),
    WOLF(Versions.VERSION_1_14, LivingEntityCategory.ANIMAL, LivingEntityCategory.BREEDABLE, LivingEntityCategory.NEUTRAL, LivingEntityCategory.TAMEABLE),
    ZOGLIN(Versions.VERSION_1_16, LivingEntityCategory.HOSTILE, LivingEntityCategory.NETHER, LivingEntityCategory.PIGLIN, LivingEntityCategory.UNDEAD),
    ZOMBIE(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.UNDEAD),
    ZOMBIE_HORSE(Versions.VERSION_1_14, LivingEntityCategory.NEUTRAL, LivingEntityCategory.UNDEAD),
    ZOMBIE_VILLAGER(Versions.VERSION_1_14, LivingEntityCategory.HOSTILE, LivingEntityCategory.VILLAGER, LivingEntityCategory.UNDEAD),
    ZOMBIFIED_PIGLIN(Versions.VERSION_1_16, LivingEntityCategory.NETHER, LivingEntityCategory.NEUTRAL, LivingEntityCategory.PIGLIN, LivingEntityCategory.UNDEAD);

    private static final LivingEntityDefinition[] VALUES;
    private final SemanticVersion lowestVersion;
    private final Set<LivingEntityCategory> categories;
    private boolean isFlying;
    private boolean isPassive;
    private boolean isHostile;
    private boolean isNeutral;
    private boolean isTameable;
    private boolean isAnimal;
    private boolean isAquatic;
    private boolean isBreedable;
    private boolean isNether;
    private boolean isArthropod;
    private boolean isFish;
    private boolean isRideable;
    private boolean isUndead;
    private boolean isEnd;
    private boolean isBoss;
    private boolean isRaid;
    private boolean isIllager;
    private boolean isPiglin;
    private boolean isGolem;
    private boolean isTrader;
    private boolean isVillager;

    @ParametersAreNonnullByDefault
    private LivingEntityDefinition(SemanticVersion lowestVersion, LivingEntityCategory ... categories) {
        this.lowestVersion = lowestVersion;
        this.categories = Sets.newHashSet((Object[])categories);
        block23: for (LivingEntityCategory category : categories) {
            switch (category) {
                case ANIMAL: {
                    this.isAnimal = true;
                    continue block23;
                }
                case AQUATIC: {
                    this.isAquatic = true;
                    continue block23;
                }
                case ARTHROPOD: {
                    this.isArthropod = true;
                    continue block23;
                }
                case BOSS: {
                    this.isBoss = true;
                    continue block23;
                }
                case BREEDABLE: {
                    this.isBreedable = true;
                    continue block23;
                }
                case END: {
                    this.isEnd = true;
                    continue block23;
                }
                case FISH: {
                    this.isFish = true;
                    continue block23;
                }
                case FLYING: {
                    this.isFlying = true;
                    continue block23;
                }
                case GOLEM: {
                    this.isGolem = true;
                    continue block23;
                }
                case HOSTILE: {
                    this.isHostile = true;
                    continue block23;
                }
                case ILLAGER: {
                    this.isIllager = true;
                    continue block23;
                }
                case NETHER: {
                    this.isNether = true;
                    continue block23;
                }
                case NEUTRAL: {
                    this.isNeutral = true;
                    continue block23;
                }
                case PASSIVE: {
                    this.isPassive = true;
                    continue block23;
                }
                case PIGLIN: {
                    this.isPiglin = true;
                    continue block23;
                }
                case RAID: {
                    this.isRaid = true;
                    continue block23;
                }
                case RIDEABLE: {
                    this.isRideable = true;
                    continue block23;
                }
                case TAMEABLE: {
                    this.isTameable = true;
                    continue block23;
                }
                case TRADER: {
                    this.isTrader = true;
                    continue block23;
                }
                case UNDEAD: {
                    this.isUndead = true;
                    continue block23;
                }
                case VILLAGER: {
                    this.isVillager = true;
                }
            }
        }
    }

    public EntityType getType() {
        return EntityType.valueOf((String)this.name());
    }

    public SemanticVersion getLowestVersion() {
        return this.lowestVersion;
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public boolean isPassive() {
        return this.isPassive;
    }

    public boolean isHostile() {
        return this.isHostile;
    }

    public boolean isNeutral() {
        return this.isNeutral;
    }

    public boolean isTameable() {
        return this.isTameable;
    }

    public boolean isAnimal() {
        return this.isAnimal;
    }

    public boolean isAquatic() {
        return this.isAquatic;
    }

    public boolean isBreedable() {
        return this.isBreedable;
    }

    public boolean isNether() {
        return this.isNether;
    }

    public boolean isArthropod() {
        return this.isArthropod;
    }

    public boolean isFish() {
        return this.isFish;
    }

    public boolean isRideable() {
        return this.isRideable;
    }

    public boolean isUndead() {
        return this.isUndead;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public boolean isBoss() {
        return this.isBoss;
    }

    public boolean isRaid() {
        return this.isRaid;
    }

    public boolean isIllager() {
        return this.isIllager;
    }

    public boolean isPiglin() {
        return this.isPiglin;
    }

    public boolean isGolem() {
        return this.isGolem;
    }

    public boolean isVillager() {
        return this.isVillager;
    }

    public boolean isTrader() {
        return this.isTrader;
    }

    public boolean existsIn(SemanticVersion version) {
        return version.isAtLeast(this.lowestVersion);
    }

    public boolean isCategorized(LivingEntityCategory category) {
        return this.categories.contains((Object)category);
    }

    public boolean isCategorized(LivingEntityCategory ... categories) {
        return this.isCategorized(Sets.newHashSet((Object[])categories));
    }

    public boolean isCategorized(Collection<LivingEntityCategory> categories) {
        for (LivingEntityCategory category : categories) {
            if (this.isCategorized(category)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static LivingEntityDefinition fromType(EntityType type) {
        for (LivingEntityDefinition value : VALUES) {
            if (!value.name().equals(type.name())) continue;
            return value;
        }
        return null;
    }

    public static LivingEntityDefinition[] getValues() {
        return Arrays.copyOf(VALUES, VALUES.length);
    }

    public static Set<LivingEntityDefinition> getByCategory(LivingEntityCategory category) {
        return LivingEntityDefinition.getByCategory(category, Versions.VERSION_EARLIEST);
    }

    public static Set<LivingEntityDefinition> getByCategory(LivingEntityCategory category, SemanticVersion version) {
        HashSet<LivingEntityDefinition> livingEntityDefinitions = new HashSet<LivingEntityDefinition>();
        for (LivingEntityDefinition definition : LivingEntityDefinition.getValues()) {
            if (!definition.isCategorized(category) || !definition.existsIn(version)) continue;
            livingEntityDefinitions.add(definition);
        }
        return livingEntityDefinitions;
    }

    static {
        VALUES = LivingEntityDefinition.values();
    }
}

