/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.utils;

import org.bukkit.Bukkit;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public final class Utils {
    public static final int BRIGHTNESS_ON = 15;
    public static final int BRIGHTNESS_OFF = 3;
    public static final int BRIGHTNESS_PANEL = 12;
    public static final int VIEW_RANGE_ON = 1;
    public static final int VIEW_RANGE_OFF = 0;
    private static final double FLOATING_POINT_THRESHOLD = 1.0E-5;

    public static double roundTo2dp(double value) {
        return (double)Math.round(value * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
    }

    public static void clampToRange(@NotNull Vector vector, float min, float max) {
        vector.setX(Math.min(vector.getX(), (double)max));
        vector.setY(Math.min(vector.getY(), (double)max));
        vector.setZ(Math.min(vector.getZ(), (double)max));
        vector.setX(Math.max(vector.getX(), (double)min));
        vector.setY(Math.max(vector.getY(), (double)min));
        vector.setZ(Math.max(vector.getZ(), (double)min));
    }

    public static double clampToRange(double value, double min, double max) {
        return Math.max(Math.min(value, max), min);
    }

    public static float clampToRange(float value, float min, float max) {
        return Math.max(Math.min(value, max), min);
    }

    public static int clampToRange(int value, int min, int max) {
        return Math.max(Math.min(value, max), min);
    }

    public static boolean equal(double a, double b) {
        return Math.abs(a - b) < 1.0E-5;
    }

    public static boolean equal(float a, float b) {
        return (double)Math.abs(a - b) < 1.0E-5;
    }

    public static int getMajorServerVersion() {
        return Integer.parseInt(Bukkit.getServer().getMinecraftVersion().split("\\.")[1]);
    }

    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

