/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.tools.raygun;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.joml.Vector3f;
import org.metamechanists.quaptics.beams.DeprecatedBeamStorage;
import org.metamechanists.quaptics.beams.beam.LifetimeDirectBeam;
import org.metamechanists.quaptics.displaymodellib.transformations.TransformationUtils;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.tools.raygun.AbstractRayGun;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;

public class DirectRayGun
extends AbstractRayGun {
    public static final Settings RAY_GUN_3_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).chargeCapacity(100000.0).outputPower(300.0).range(56).damage(6.0).projectileMaterial(Material.LIME_CONCRETE).build();
    public static final Settings RAY_GUN_4_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).chargeCapacity(1000000.0).outputPower(2000.0).range(56).damage(12.0).projectileMaterial(Material.LIME_CONCRETE).build();
    public static final SlimefunItemStack RAY_GUN_3 = new SlimefunItemStack("QP_RAY_GUN_3", Material.GOLDEN_HORSE_ARMOR, "&bRay Gun &3III", Lore.buildChargeableLore(RAY_GUN_3_SETTINGS, 0, "&7\u25cf &eRight Click &7to fire"));
    public static final SlimefunItemStack RAY_GUN_4 = new SlimefunItemStack("QP_RAY_GUN_4", Material.DIAMOND_HORSE_ARMOR, "&bRay Gun &3IV", Lore.buildChargeableLore(RAY_GUN_4_SETTINGS, 0, "&7\u25cf &eRight Click &7to fire"));

    public DirectRayGun(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    public void fireRayGun(Player player, Location eyeLocation, Location handLocation, Location target) {
        RayTraceResult result = eyeLocation.getWorld().rayTrace(eyeLocation.clone(), Vector.fromJOML((Vector3f)TransformationUtils.getDisplacement(eyeLocation, target)), (double)this.settings.getRange(), FluidCollisionMode.NEVER, true, (double)0.095f, entity -> !entity.getUniqueId().equals(player.getUniqueId()) && !(entity instanceof Display) && !(entity instanceof org.bukkit.entity.Interaction) && !(entity instanceof ArmorStand));
        if (result == null) {
            DeprecatedBeamStorage.deprecate(new LifetimeDirectBeam(this.settings.getProjectileMaterial(), handLocation, target, 0.095f, 0.0f, 5));
            return;
        }
        Vector position = result.getHitPosition();
        DeprecatedBeamStorage.deprecate(new LifetimeDirectBeam(this.settings.getProjectileMaterial(), handLocation, new Location(handLocation.getWorld(), position.getX(), position.getY(), position.getZ()), 0.095f, 0.0f, 5));
        Entity entity2 = result.getHitEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            if (Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, livingEntity.getLocation(), Interaction.ATTACK_ENTITY)) {
                livingEntity.damage(this.settings.getDamage());
                livingEntity.setVelocity(Vector.fromJOML((Vector3f)TransformationUtils.getDisplacement(handLocation, livingEntity.getEyeLocation()).mul(0.2f)));
            }
        }
    }
}

