/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.upgraders;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerLossBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.Utils;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;

public class DiffractionGrating
extends ConnectedBlock
implements PowerAnimatedBlock,
PowerLossBlock {
    public static final Settings DIFFRACTION_GRATING_1_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).maxPowerHidden(true).minPower(360.0).powerLoss(0.05).minFrequency(200.0).maxFrequency(1000.0).frequencyMultiplier(1.8).targetPhase(168).targetPhaseSpread(60).build();
    public static final Settings DIFFRACTION_GRATING_2_SETTINGS = Settings.builder().tier(Tier.ADVANCED).maxPowerHidden(true).minPower(1600.0).powerLoss(0.01).minFrequency(6000.0).maxFrequency(40000.0).frequencyMultiplier(2.0).targetPhase(267).targetPhaseSpread(60).build();
    public static final SlimefunItemStack DIFFRACTION_GRATING_1 = new SlimefunItemStack("QP_DIFFRACTION_GRATING_1", Material.YELLOW_TERRACOTTA, "&cDiffraction Grating &4I", Lore.create(DIFFRACTION_GRATING_1_SETTINGS, "&7\u25cf Increases the frequency of quaptic rays", "&7\u25cf The closer the auxiliary input to the target phase, the", "&7  greater the increase in frequency", "&7\u25cf The operating power & frequency only apply to the main beam", "&7\u25cf The target phase only applies to the auxiliary beam"));
    public static final SlimefunItemStack DIFFRACTION_GRATING_2 = new SlimefunItemStack("QP_DIFFRACTION_GRATING_2", Material.YELLOW_TERRACOTTA, "&cDiffraction Grating &4II", Lore.create(DIFFRACTION_GRATING_2_SETTINGS, "&7\u25cf Increases the frequency of quaptic rays", "&7\u25cf The closer the auxiliary input to the target phase, the", "&7  greater the increase in frequency", "&7\u25cf The operating power & frequency only apply to the main beam", "&7\u25cf The target phase only applies to the auxiliary beam"));
    private final Vector mainPointLocation = new Vector(0.0, 0.0, -0.5);
    private final Vector auxiliaryPointLocation = new Vector(0.0, 0.4, 0.0);
    private final Vector outputPointLocation = new Vector(0.0, 0.0, 0.5);

    public DiffractionGrating(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.0f;
    }

    @Override
    public void connect(@NotNull ConnectionPointId from, @NotNull ConnectionPointId to) {
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("main", new ModelCuboid().material(Material.YELLOW_TERRACOTTA).facing(player.getFacing()).size(0.2f, 0.2f, 1.0f)).add("auxiliary", new ModelCuboid().material(Material.GRAY_CONCRETE).facing(player.getFacing()).size(0.15f, 0.4f, 0.15f).location(0.0f, 0.2f, 0.0f)).add("prism", new ModelCuboid().material(Material.GRAY_CONCRETE).brightness(3).facing(player.getFacing()).size(0.4f).rotation(0.7853981633974483)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "main", DiffractionGrating.formatPointLocation(player, location, this.mainPointLocation)), new ConnectionPoint(ConnectionPointType.INPUT, groupId, "auxiliary", DiffractionGrating.formatPointLocation(player, location, this.auxiliaryPointLocation)), new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output", DiffractionGrating.formatPointLocation(player, location, this.outputPointLocation)));
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        Optional<Link> mainLink = DiffractionGrating.getLink(location, "main");
        Optional<Link> auxiliaryLink = DiffractionGrating.getLink(location, "auxiliary");
        Optional<Link> outputLink = DiffractionGrating.getLink(location, "output");
        boolean powered = auxiliaryLink.isPresent() && mainLink.isPresent() && this.settings.isOperational(mainLink);
        this.onPoweredAnimation(location, powered);
        if (outputLink.isEmpty()) {
            return;
        }
        if (!powered) {
            outputLink.get().disable();
            return;
        }
        double newFrequency = DiffractionGrating.calculateFrequency(this.settings, mainLink.get().getFrequency(), auxiliaryLink.get().getPhase());
        if (Utils.equal(newFrequency, mainLink.get().getFrequency())) {
            outputLink.get().disable();
            this.onPoweredAnimation(location, false);
            return;
        }
        outputLink.get().setPowerFrequencyPhase(PowerLossBlock.calculatePowerLoss(this.settings, mainLink.get()), DiffractionGrating.calculateFrequency(this.settings, mainLink.get().getFrequency(), auxiliaryLink.get().getPhase()), mainLink.get().getPhase());
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "prism", powered);
    }

    private static double calculateFrequency(@NotNull Settings settings, double frequency, int phase) {
        int phaseDifference = Math.abs(phase - settings.getTargetPhase());
        double targetPhaseDifference = Math.max(settings.getTargetPhaseSpread() - phaseDifference, 0);
        double targetPhaseProportion = targetPhaseDifference / (double)settings.getTargetPhaseSpread();
        return frequency * (1.0 + targetPhaseProportion * (settings.getFrequencyMultiplier() - 1.0));
    }
}

