/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.connections;

import java.util.Optional;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.builders.InteractionBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.panels.info.InfoPanel;
import org.metamechanists.quaptics.panels.info.implementation.PointInfoPanel;
import org.metamechanists.quaptics.schedulers.PointPanelUpdateScheduler;
import org.metamechanists.quaptics.storage.PersistentDataTraverser;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;
import org.metamechanists.quaptics.utils.id.complex.LinkId;
import org.metamechanists.quaptics.utils.id.simple.BlockDisplayId;
import org.metamechanists.quaptics.utils.id.simple.InteractionId;

public class ConnectionPoint {
    private static final float SIZE = 0.1f;
    private static final Vector3f INTERACTION_OFFSET = new Vector3f(0.0f, -0.05f, 0.0f);
    private static final Color SELECTED_COLOR = Color.fromRGB((int)0, (int)255, (int)0);
    private static final ModelCuboid BLOCK_DISPLAY = new ModelCuboid().brightness(3).size(0.1f);
    private final ConnectionPointType type;
    private final ConnectionGroupId groupId;
    private final InteractionId interactionId;
    private final BlockDisplayId blockDisplayId;
    @Nullable
    private final InfoPanelId panelId;
    @Nullable
    private LinkId linkId;
    private final String name;

    public ConnectionPoint(@NotNull ConnectionPointType type, ConnectionGroupId groupId, String name, @NotNull Location location) {
        Interaction interaction = new InteractionBuilder().width(0.1f).height(0.1f).build(location);
        this.type = type;
        this.groupId = groupId;
        this.interactionId = new InteractionId(interaction.getUniqueId());
        this.blockDisplayId = new BlockDisplayId(BLOCK_DISPLAY.material(type.getMaterial()).build(location).getUniqueId());
        this.panelId = new PointInfoPanel(location, this.getId()).getId();
        this.name = name;
        this.saveData();
        this.updatePanel();
    }

    public ConnectionPoint(ConnectionPointId pointId) {
        PersistentDataTraverser traverser = new PersistentDataTraverser(pointId);
        this.type = traverser.getConnectionPointType("connectionPointType");
        this.groupId = traverser.getConnectionGroupId("groupId");
        this.blockDisplayId = traverser.getBlockDisplayId("blockDisplayId");
        this.interactionId = traverser.getInteractionId("interactionId");
        this.panelId = traverser.getInfoPanelId("panelId");
        this.linkId = traverser.getLinkId("linkId");
        this.name = traverser.getString("name");
    }

    private void saveData() {
        PersistentDataTraverser traverser = new PersistentDataTraverser(this.getId());
        traverser.set("connectionPointType", this.type);
        traverser.set("groupId", this.groupId);
        traverser.set("blockDisplayId", this.blockDisplayId);
        traverser.set("interactionId", this.interactionId);
        traverser.set("panelId", this.panelId);
        traverser.set("linkId", this.linkId);
        traverser.set("name", this.name);
    }

    public boolean isOutput() {
        return this.type == ConnectionPointType.OUTPUT;
    }

    public boolean isInput() {
        return this.type == ConnectionPointType.INPUT;
    }

    public boolean isLinkEnabled() {
        return this.getLink().isPresent() && this.getLink().get().isEnabled();
    }

    @NotNull
    public final ConnectionPointId getId() {
        return new ConnectionPointId(this.interactionId);
    }

    public Optional<Link> getLink() {
        return this.linkId == null ? Optional.empty() : this.linkId.get();
    }

    public Optional<Location> getLocation() {
        return this.getBlockDisplay().isPresent() ? Optional.of(this.getBlockDisplay().get().getLocation()) : Optional.empty();
    }

    public Optional<PointInfoPanel> getPointPanel() {
        return this.panelId == null ? Optional.empty() : Optional.of(new PointInfoPanel(this.panelId, this.getId()));
    }

    private Optional<BlockDisplay> getBlockDisplay() {
        return this.blockDisplayId.get();
    }

    private Optional<Interaction> getInteraction() {
        return this.interactionId.get();
    }

    public Optional<ConnectionGroup> getGroup() {
        return this.groupId.get();
    }

    public void remove() {
        this.getLink().ifPresent(Link::remove);
        this.getPointPanel().ifPresent(InfoPanel::remove);
        this.getBlockDisplay().ifPresent(Entity::remove);
        this.getInteraction().ifPresent(Entity::remove);
    }

    public void changeLocation(@NotNull Location location) {
        this.getBlockDisplay().ifPresent(blockDisplay -> blockDisplay.teleport(location));
        this.getInteraction().ifPresent(interaction -> interaction.teleport(location.clone().add(Vector.fromJOML((Vector3f)INTERACTION_OFFSET))));
        this.getPointPanel().ifPresent(panel -> panel.changeLocation(location));
        this.saveData();
    }

    public void updatePanel() {
        PointPanelUpdateScheduler.scheduleUpdate(this.panelId, this.getId());
    }

    public void togglePanelHidden() {
        this.getPointPanel().ifPresent(InfoPanel::togglePanelHidden);
    }

    public void unlink() {
        this.linkId = null;
        this.getBlockDisplay().ifPresent(blockDisplay -> blockDisplay.setBrightness(new Display.Brightness(3, 0)));
        this.saveData();
        this.updatePanel();
    }

    public void link(LinkId linkId) {
        this.unlink();
        this.linkId = linkId;
        this.getBlockDisplay().ifPresent(blockDisplay -> blockDisplay.setBrightness(new Display.Brightness(15, 0)));
        this.saveData();
        this.updatePanel();
    }

    public void select() {
        this.getBlockDisplay().ifPresent(blockDisplay -> {
            blockDisplay.setGlowing(true);
            blockDisplay.setGlowColorOverride(SELECTED_COLOR);
        });
    }

    public void deselect() {
        this.getBlockDisplay().ifPresent(blockDisplay -> blockDisplay.setGlowing(false));
    }

    public InteractionId getInteractionId() {
        return this.interactionId;
    }

    public String getName() {
        return this.name;
    }
}

