/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics;

import co.aikar.commands.PaperCommandManager;
import io.github.bakedlibs.dough.updater.GitHubBuildsUpdater;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.commands.QuapticsCommand;
import org.metamechanists.quaptics.implementation.blocks.consumers.launchpad.LaunchpadListener;
import org.metamechanists.quaptics.implementation.burnout.BurnoutManager;
import org.metamechanists.quaptics.implementation.multiblocks.beacons.controllers.ModuleClickListener;
import org.metamechanists.quaptics.implementation.multiblocks.beacons.modules.player.ExperienceModuleListener;
import org.metamechanists.quaptics.implementation.tools.multiblockwand.MultiblockWandListener;
import org.metamechanists.quaptics.implementation.tools.targetingwand.TargetingWandListener;
import org.metamechanists.quaptics.items.Groups;
import org.metamechanists.quaptics.metalib.bstats.bukkit.Metrics;
import org.metamechanists.quaptics.panels.config.ConfigPanelListener;
import org.metamechanists.quaptics.panels.info.implementation.PointInfoPanelListener;
import org.metamechanists.quaptics.storage.CacheGarbageCollector;
import org.metamechanists.quaptics.storage.QuapticStorage;
import org.metamechanists.quaptics.storage.QuapticTicker;

public final class Quaptics
extends JavaPlugin
implements SlimefunAddon {
    private static final int BSTATS_ID = 18956;
    private static Quaptics instance;

    private void initializeListeners() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new TargetingWandListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PointInfoPanelListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new LaunchpadListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new ConfigPanelListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new BurnoutManager(), (Plugin)this);
        pluginManager.registerEvents((Listener)new MultiblockWandListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new ModuleClickListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new QuapticStorage(), (Plugin)this);
        pluginManager.registerEvents((Listener)new ExperienceModuleListener(), (Plugin)this);
    }

    private void initializeRunnables() {
        new QuapticTicker().runTaskTimer((Plugin)this, 0L, 2L);
        new CacheGarbageCollector().runTaskTimer((Plugin)this, 601L, 601L);
    }

    private void initializeCommands() {
        PaperCommandManager commandManager = new PaperCommandManager((Plugin)this);
        commandManager.registerCommand(new QuapticsCommand());
        commandManager.enableUnstableAPI("help");
    }

    public void onEnable() {
        if (!PaperLib.isPaper()) {
            this.getLogger().severe("Quaptics requires Paper to run!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.saveDefaultConfig();
        if (this.getConfig().getBoolean("auto-update") && this.getDescription().getVersion().startsWith("DEV")) {
            new GitHubBuildsUpdater((Plugin)this, this.getFile(), "LordIdra/Quaptics/master").start();
        }
        instance = this;
        Groups.initialize();
        this.initializeListeners();
        this.initializeRunnables();
        this.initializeCommands();
        new Metrics(this, 18956);
    }

    public void onDisable() {
        BurnoutManager.stopBurnouts();
    }

    @NotNull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    @NotNull
    public String getBugTrackerURL() {
        return "https://github.com/lordidra/Quaptics/issues";
    }

    public static Quaptics getInstance() {
        return instance;
    }
}

