/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.storage;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.beams.beam.DirectBeam;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.panels.config.ConfigPanelAttribute;
import org.metamechanists.quaptics.panels.config.ConfigPanelContainer;
import org.metamechanists.quaptics.panels.info.InfoPanelAttribute;
import org.metamechanists.quaptics.panels.info.InfoPanelContainer;
import org.metamechanists.quaptics.utils.id.ComplexCustomId;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelAttributeId;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;
import org.metamechanists.quaptics.utils.id.complex.DirectBeamId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelAttributeId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;
import org.metamechanists.quaptics.utils.id.complex.LinkId;

public final class QuapticCache {
    private static final Map<DirectBeamId, DirectBeam> directBeams = new ConcurrentHashMap<DirectBeamId, DirectBeam>();
    private static final Map<ConnectionGroupId, ConnectionGroup> connectionGroups = new ConcurrentHashMap<ConnectionGroupId, ConnectionGroup>();
    private static final Map<ConnectionPointId, ConnectionPoint> connectionPoints = new ConcurrentHashMap<ConnectionPointId, ConnectionPoint>();
    private static final Map<LinkId, Link> links = new ConcurrentHashMap<LinkId, Link>();
    private static final Map<InfoPanelAttributeId, InfoPanelAttribute> infoPanelAttributes = new ConcurrentHashMap<InfoPanelAttributeId, InfoPanelAttribute>();
    private static final Map<InfoPanelId, InfoPanelContainer> infoPanels = new ConcurrentHashMap<InfoPanelId, InfoPanelContainer>();
    private static final Map<ConfigPanelAttributeId, ConfigPanelAttribute> configPanelAttributes = new ConcurrentHashMap<ConfigPanelAttributeId, ConfigPanelAttribute>();
    private static final Map<ConfigPanelId, ConfigPanelContainer> configPanels = new ConcurrentHashMap<ConfigPanelId, ConfigPanelContainer>();

    private static void garbageCollect(@NotNull Map<? extends ComplexCustomId, ?> map) {
        map.keySet().stream().filter(x -> !x.isValid()).forEach(map::remove);
    }

    public static void garbageCollect() {
        QuapticCache.garbageCollect(directBeams);
        QuapticCache.garbageCollect(connectionGroups);
        QuapticCache.garbageCollect(connectionPoints);
        QuapticCache.garbageCollect(links);
        QuapticCache.garbageCollect(infoPanelAttributes);
        QuapticCache.garbageCollect(infoPanels);
    }

    public static Optional<DirectBeam> getBeam(DirectBeamId id) {
        if (!directBeams.containsKey(id)) {
            directBeams.put(id, new DirectBeam(id));
        }
        return Optional.ofNullable(directBeams.get(id));
    }

    public static Optional<ConnectionGroup> getConnectionGroup(ConnectionGroupId id) {
        if (!connectionGroups.containsKey(id)) {
            connectionGroups.put(id, new ConnectionGroup(id));
        }
        return Optional.ofNullable(connectionGroups.get(id));
    }

    public static Optional<ConnectionPoint> getConnectionPoint(ConnectionPointId id) {
        if (!connectionPoints.containsKey(id)) {
            connectionPoints.put(id, new ConnectionPoint(id));
        }
        return Optional.ofNullable(connectionPoints.get(id));
    }

    public static Optional<Link> getLink(LinkId id) {
        if (!links.containsKey(id)) {
            links.put(id, new Link(id));
        }
        return Optional.ofNullable(links.get(id));
    }

    public static Optional<InfoPanelAttribute> getInfoPanelAttribute(InfoPanelAttributeId id) {
        if (!infoPanelAttributes.containsKey(id)) {
            infoPanelAttributes.put(id, new InfoPanelAttribute(id));
        }
        return Optional.ofNullable(infoPanelAttributes.get(id));
    }

    public static Optional<InfoPanelContainer> getInfoPanel(InfoPanelId id) {
        if (!infoPanels.containsKey(id)) {
            infoPanels.put(id, new InfoPanelContainer(id));
        }
        return Optional.ofNullable(infoPanels.get(id));
    }

    public static Optional<ConfigPanelContainer> getConfigPanel(ConfigPanelId id) {
        if (!configPanels.containsKey(id)) {
            configPanels.put(id, new ConfigPanelContainer(id));
        }
        return Optional.ofNullable(configPanels.get(id));
    }

    public static Optional<ConfigPanelAttribute> getConfigPanelAttribute(ConfigPanelAttributeId id) {
        if (!configPanelAttributes.containsKey(id)) {
            configPanelAttributes.put(id, new ConfigPanelAttribute(id));
        }
        return Optional.ofNullable(configPanelAttributes.get(id));
    }

    private QuapticCache() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

