/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.tools.raygun;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.metamechanists.quaptics.beams.DeprecatedBeamStorage;
import org.metamechanists.quaptics.beams.beam.ProjectileBeam;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.tools.raygun.AbstractRayGun;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;

public class ModulatedRayGun
extends AbstractRayGun {
    public static final Settings RAY_GUN_1_SETTINGS = Settings.builder().tier(Tier.PRIMITIVE).chargeCapacity(1000.0).outputPower(5.0).range(56).damage(1.5).projectileSpeed(12.0f).projectileMaterial(Material.LIGHT_BLUE_CONCRETE).build();
    public static final Settings RAY_GUN_2_SETTINGS = Settings.builder().tier(Tier.BASIC).chargeCapacity(10000.0).outputPower(40.0).range(56).damage(3.0).projectileSpeed(30.0f).projectileMaterial(Material.LIGHT_BLUE_CONCRETE).build();
    public static final SlimefunItemStack RAY_GUN_1 = new SlimefunItemStack("QP_RAY_GUN_1", Material.LEATHER_HORSE_ARMOR, "&bRay Gun &3I", Lore.buildChargeableLore(RAY_GUN_1_SETTINGS, 0, "&7\u25cf &eRight Click &7to fire"));
    public static final SlimefunItemStack RAY_GUN_2 = new SlimefunItemStack("QP_RAY_GUN_2", Material.IRON_HORSE_ARMOR, "&bRay Gun &3II", Lore.buildChargeableLore(RAY_GUN_2_SETTINGS, 0, "&7\u25cf &eRight Click &7to fire"));

    public ModulatedRayGun(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    public void fireRayGun(Player player, Location eyeLocation, Location handLocation, Location target) {
        DeprecatedBeamStorage.deprecate(new ProjectileBeam(player, this.settings.getProjectileMaterial(), handLocation, target, 0.095f, 0.2f, this.settings.getProjectileSpeed() * 2.0f / 20.0f, this.settings.getDamage(), (int)((float)(20 * this.settings.getRange()) / this.settings.getProjectileSpeed())));
    }
}

