/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.multiblocks.infuser;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelItem;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.ItemHolderBlock;
import org.metamechanists.quaptics.implementation.multiblocks.infuser.IndustrialInfusionPillar;
import org.metamechanists.quaptics.implementation.multiblocks.infuser.InfusionContainer;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.metalib.utils.ItemUtils;
import org.metamechanists.quaptics.utils.BlockStorageAPI;

public class IndustrialInfusionContainer
extends InfusionContainer {
    public static final Settings INDUSTRIAL_INFUSION_CONTAINER_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).operatingPowerHidden(true).timePerItem(15.0).build();
    public static final SlimefunItemStack INDUSTRIAL_INFUSION_CONTAINER = new SlimefunItemStack("QP_INDUSTRIAL_INFUSION_CONTAINER", Material.GRAY_CONCRETE, "&6Industrial Infusion Container", Lore.create(INDUSTRIAL_INFUSION_CONTAINER_SETTINGS, Lore.multiblock(), "&7\u25cf Infuses items", "&7\u25cf Can infuse up to 16 items at once", "&7\u25cf &eRight Click &7with an item to start infusing"));
    private static final Map<Vector, ItemStack> PILLARS = Map.of(new Vector(3, 0, 0), IndustrialInfusionPillar.INDUSTRIAL_INFUSION_PILLAR, new Vector(2, 0, 2), IndustrialInfusionPillar.INDUSTRIAL_INFUSION_PILLAR, new Vector(0, 0, 3), IndustrialInfusionPillar.INDUSTRIAL_INFUSION_PILLAR, new Vector(-2, 0, 2), IndustrialInfusionPillar.INDUSTRIAL_INFUSION_PILLAR, new Vector(-3, 0, 0), IndustrialInfusionPillar.INDUSTRIAL_INFUSION_PILLAR, new Vector(-2, 0, -2), IndustrialInfusionPillar.INDUSTRIAL_INFUSION_PILLAR, new Vector(0, 0, -3), IndustrialInfusionPillar.INDUSTRIAL_INFUSION_PILLAR, new Vector(2, 0, -2), IndustrialInfusionPillar.INDUSTRIAL_INFUSION_PILLAR);

    public IndustrialInfusionContainer(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("base", new ModelCuboid().material(Material.GRAY_CONCRETE).facing(player.getFacing()).size(1.3f, 0.4f, 1.3f).location(0.0f, -0.3f, 0.0f)).add("pillar1", new ModelCuboid().material(Material.ORANGE_CONCRETE).facing(player.getFacing()).location(-0.6f, -0.1f, -0.6f).size(0.25f, 0.8f, 0.25f)).add("pillar2", new ModelCuboid().material(Material.ORANGE_CONCRETE).facing(player.getFacing()).location(-0.6f, -0.1f, 0.6f).size(0.25f, 0.8f, 0.25f)).add("pillar3", new ModelCuboid().material(Material.ORANGE_CONCRETE).facing(player.getFacing()).location(0.6f, -0.1f, -0.6f).size(0.25f, 0.8f, 0.25f)).add("pillar4", new ModelCuboid().material(Material.ORANGE_CONCRETE).facing(player.getFacing()).location(0.6f, -0.1f, 0.6f).size(0.25f, 0.8f, 0.25f)).add("plate", new ModelCuboid().material(Material.WHITE_CONCRETE).facing(player.getFacing()).location(0.0f, -0.1f, 0.0f).size(0.6f, 0.1f, 0.6f)).add("item", new ModelItem().brightness(15).location(0.0f, 0.4f, 0.0f).size(0.8f)).buildAtBlockCenter(location);
    }

    @Override
    public Map<ItemStack, ItemStack> getRecipes() {
        HashMap<ItemStack, ItemStack> recipes = new HashMap<ItemStack, ItemStack>();
        for (Map.Entry<ItemStack, ItemStack> recipe : super.getRecipes().entrySet()) {
            for (int i = 0; i < 16; ++i) {
                ItemStack input = recipe.getKey().clone();
                ItemStack output = recipe.getValue().clone();
                input.add(i);
                output.add(i);
                recipes.put(input, output);
            }
        }
        return recipes;
    }

    @Override
    public Map<Vector, ItemStack> getStructure() {
        return PILLARS;
    }

    @Override
    public void itemHolderInteract(@NotNull Location location, @NotNull String name, @NotNull Player player) {
        Optional currentStack = this.removeItem(location, name);
        BlockStorageAPI.set(location, "QP_IS_HOLDING_ITEM", false);
        if (currentStack.isPresent() && !this.isEmptyItemStack((ItemStack)currentStack.get())) {
            this.onRemove(location, name, (ItemStack)currentStack.get()).ifPresent(itemStack -> ItemUtils.addOrDropItemMainHand(player, itemStack));
            return;
        }
        ItemStack itemStack2 = player.getInventory().getItemInMainHand();
        int amount = Math.min(itemStack2.getAmount(), 16);
        ItemStack newItemStack = itemStack2.clone();
        newItemStack.setAmount(amount);
        if (newItemStack.getType().isEmpty() || !this.onInsert(location, name, newItemStack, player)) {
            return;
        }
        itemStack2.subtract(amount);
        ItemHolderBlock.insertItem(location, name, newItemStack);
        BlockStorageAPI.set(location, "QP_IS_HOLDING_ITEM", true);
    }
}

