/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.multiblocks.entangler;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelDiamond;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class EntanglementMagnet
extends ConnectedBlock
implements PowerAnimatedBlock {
    public static final Settings ENTANGLEMENT_MAGNET_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).minPower(100.0).minFrequency(200.0).build();
    public static final SlimefunItemStack ENTANGLEMENT_MAGNET = new SlimefunItemStack("QP_ENTANGLEMENT_MAGNET", Material.MAGENTA_CONCRETE, "&6Entanglement Magnet", Lore.create(ENTANGLEMENT_MAGNET_SETTINGS, Lore.multiblockComponent()));
    private final Vector inputPointLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());

    public EntanglementMagnet(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.45f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("diamond", new ModelDiamond().material(Material.GRAY_CONCRETE).size(0.5f)).add("panel1", new ModelCuboid().material(Material.MAGENTA_CONCRETE).brightness(3).size(0.4f, 0.2f, 0.2f).rotation(ModelDiamond.ROTATION)).add("panel2", new ModelCuboid().material(Material.MAGENTA_CONCRETE).brightness(3).size(0.2f, 0.4f, 0.2f).rotation(ModelDiamond.ROTATION)).add("panel3", new ModelCuboid().material(Material.MAGENTA_CONCRETE).brightness(3).size(0.2f, 0.2f, 0.4f).rotation(ModelDiamond.ROTATION)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", EntanglementMagnet.formatPointLocation(player, location, this.inputPointLocation)));
    }

    @Override
    protected void initBlockStorage(@NotNull Location location) {
        BlockStorageAPI.set(location, "QP_POWERED", false);
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (this.doBurnoutCheck(group, "input")) {
            return;
        }
        Optional<Link> link = EntanglementMagnet.getLink(location, "input");
        this.onPoweredAnimation(location, this.settings.isOperational(link));
        BlockStorageAPI.set(location, "QP_POWERED", this.settings.isOperational(link));
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "panel1", powered);
        this.brightnessAnimation(location, "panel2", powered);
        this.brightnessAnimation(location, "panel3", powered);
    }
}

