/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.testing;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class OscillatingConcentrator
extends ConnectedBlock {
    public static final Settings OSCILLATING_CONCENTRATOR_SETTINGS = Settings.builder().tier(Tier.TESTING).outputPower(1.0).build();
    public static final SlimefunItemStack OSCILLATING_CONCENTRATOR = new SlimefunItemStack("QP_TESTING_OSCILLATING_CONCENTRATOR", Material.BLACK_STAINED_GLASS_PANE, "&8Oscillating Concentrator &FI", Lore.create(OSCILLATING_CONCENTRATOR_SETTINGS, "&7\u25cf Toggles power on/off every tick", "&7\u25cf Concentrates epic admin hax into a quaptic ray"));
    private final Vector outputLocation = new Vector(0.0f, 0.0f, this.getConnectionRadius());

    public OscillatingConcentrator(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.45f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("center", new ModelCuboid().material(Material.WHITE_CONCRETE).brightness(3).size(0.2f)).add("plate", new ModelCuboid().material(Material.BLACK_STAINED_GLASS).rotation(0.7853981633974483).size(0.6f, 0.1f, 0.6f)).add("glass", new ModelCuboid().material(Material.GLASS).rotation(0.7853981633974483).size(0.4f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output", OscillatingConcentrator.formatPointLocation(player, location, this.outputLocation)));
    }

    @Override
    protected boolean isTicker() {
        return true;
    }

    @Override
    public void onTick2(@NotNull ConnectionGroup group, @NotNull Location location) {
        boolean enabled = OscillatingConcentrator.isEnabled(location);
        double power = enabled ? this.settings.getOutputPower() : 0.0;
        OscillatingConcentrator.getLink(location, "output").ifPresent(link -> link.setPower(power));
        OscillatingConcentrator.setEnabled(location, !enabled);
    }

    private static boolean isEnabled(Location location) {
        return BlockStorageAPI.getBoolean(location, "QP_POWERED");
    }

    private static void setEnabled(Location location, boolean enabled) {
        BlockStorageAPI.set(location, "QP_POWERED", enabled);
    }
}

