/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.manipulators;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerLossBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class Transformer
extends ConnectedBlock
implements PowerAnimatedBlock,
PowerLossBlock {
    public static final Settings TRANSFORMER_1_SETTINGS = Settings.builder().tier(Tier.BASIC).outputPower(10.0).minPower(10.0).build();
    public static final Settings TRANSFORMER_2_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).outputPower(100.0).minPower(100.0).build();
    public static final Settings TRANSFORMER_3_SETTINGS = Settings.builder().tier(Tier.ADVANCED).outputPower(1000.0).minPower(1000.0).build();
    public static final SlimefunItemStack TRANSFORMER_1 = new SlimefunItemStack("QP_TRANSFORMER_1", Material.BLACK_TERRACOTTA, "&9Transformer &8I", Lore.create(TRANSFORMER_1_SETTINGS, "&7\u25cf Drops the power of a quaptic ray", "&7\u25cf Excess input power is wasted"));
    public static final SlimefunItemStack TRANSFORMER_2 = new SlimefunItemStack("QP_TRANSFORMER_2", Material.BLACK_TERRACOTTA, "&9Transformer &8II", Lore.create(TRANSFORMER_2_SETTINGS, "&7\u25cf Drops the power of a quaptic ray", "&7\u25cf Excess input power is wasted"));
    public static final SlimefunItemStack TRANSFORMER_3 = new SlimefunItemStack("QP_TRANSFORMER_3", Material.BLACK_TERRACOTTA, "&9Transformer &8III", Lore.create(TRANSFORMER_3_SETTINGS, "&7\u25cf Drops the power of a quaptic ray", "&7\u25cf Excess input power is wasted"));
    private final Vector inputPointLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());
    private final Vector outputPointLocation = new Vector(0.0f, 0.0f, this.getConnectionRadius());

    public Transformer(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.55f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("main", new ModelCuboid().material(Material.LIGHT_GRAY_CONCRETE).facing(player.getFacing()).size(0.3f, 0.3f, 0.8f)).add("coil1", new ModelCuboid().material(this.settings.getTier().concreteMaterial).brightness(3).facing(player.getFacing()).location(0.0f, 0.0f, 0.25f).size(0.2f, 0.6f, 0.2f)).add("coil2", new ModelCuboid().material(this.settings.getTier().concreteMaterial).brightness(3).facing(player.getFacing()).location(0.0f, 0.0f, -0.25f).size(0.2f, 0.6f, 0.2f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", Transformer.formatPointLocation(player, location, this.inputPointLocation)), new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output", Transformer.formatPointLocation(player, location, this.outputPointLocation)));
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (this.doBurnoutCheck(group, "input")) {
            return;
        }
        Optional<Link> outputLink = Transformer.getLink(location, "output");
        Optional<Link> inputLink = Transformer.getLink(location, "input");
        this.onPoweredAnimation(location, this.settings.isOperational(inputLink));
        if (outputLink.isEmpty()) {
            return;
        }
        if (inputLink.isEmpty() || !this.settings.isOperational(inputLink)) {
            outputLink.get().disable();
            return;
        }
        outputLink.get().setPowerFrequencyPhase(this.settings.getOutputPower(), inputLink.get().getFrequency(), inputLink.get().getPhase());
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "coil1", powered);
        this.brightnessAnimation(location, "coil2", powered);
    }
}

