/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.manipulators;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Optional;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelDiamond;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.ChargeHolder;
import org.metamechanists.quaptics.implementation.attachments.InfoPanelBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerLossBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.panels.info.BlockInfoPanel;
import org.metamechanists.quaptics.panels.info.implementation.CapacitorInfoPanel;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Utils;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;

public class Capacitor
extends ConnectedBlock
implements InfoPanelBlock,
PowerLossBlock,
ChargeHolder {
    public static final Settings CAPACITOR_1_SETTINGS = Settings.builder().tier(Tier.PRIMITIVE).chargeCapacity(800.0).outputPower(3.0).powerLoss(0.25).build();
    public static final Settings CAPACITOR_2_SETTINGS = Settings.builder().tier(Tier.BASIC).chargeCapacity(1200.0).outputPower(35.0).powerLoss(0.16).build();
    public static final Settings CAPACITOR_3_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).chargeCapacity(16000.0).outputPower(400.0).powerLoss(0.08).build();
    public static final Settings CAPACITOR_4_SETTINGS = Settings.builder().tier(Tier.ADVANCED).chargeCapacity(200000.0).outputPower(4500.0).powerLoss(0.04).build();
    public static final SlimefunItemStack CAPACITOR_1 = new SlimefunItemStack("QP_CAPACITOR_1", Material.LIGHT_BLUE_CONCRETE, "&9Capacitor &8I", Lore.create(CAPACITOR_1_SETTINGS, "&7\u25cf Stores charge"));
    public static final SlimefunItemStack CAPACITOR_2 = new SlimefunItemStack("QP_CAPACITOR_2", Material.LIGHT_BLUE_CONCRETE, "&9Capacitor &8II", Lore.create(CAPACITOR_2_SETTINGS, "&7\u25cf Stores charge"));
    public static final SlimefunItemStack CAPACITOR_3 = new SlimefunItemStack("QP_CAPACITOR_3", Material.LIGHT_BLUE_CONCRETE, "&9Capacitor &8III", Lore.create(CAPACITOR_3_SETTINGS, "&7\u25cf Stores charge"));
    public static final SlimefunItemStack CAPACITOR_4 = new SlimefunItemStack("QP_CAPACITOR_4", Material.LIGHT_BLUE_CONCRETE, "&9Capacitor &8IV", Lore.create(CAPACITOR_4_SETTINGS, "&7\u25cf Stores charge"));
    private static final float MAX_CONCRETE_DISPLAY_SIZE = 0.78f;
    private final Vector inputPointLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());
    private final Vector outputPointLocation = new Vector(0.0f, 0.0f, this.getConnectionRadius());

    public Capacitor(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.6f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("concrete", new ModelDiamond().material(Material.LIGHT_BLUE_CONCRETE).brightness(15)).add("mainGlass", new ModelDiamond().material(Material.GLASS).size(0.85f)).add("tierGlass", new ModelDiamond().material(this.settings.getTier().glassMaterial).size(0.8f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", Capacitor.formatPointLocation(player, location, this.inputPointLocation)), new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output", Capacitor.formatPointLocation(player, location, this.outputPointLocation)));
    }

    @Override
    public BlockInfoPanel createPanel(Location location, @NotNull ConnectionGroup group) {
        return new CapacitorInfoPanel(location, group.getId());
    }

    @Override
    public BlockInfoPanel getPanel(InfoPanelId panelId, ConnectionGroupId groupId) {
        return new CapacitorInfoPanel(panelId, groupId);
    }

    @Override
    protected boolean isTicker() {
        return true;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onPlace(@NotNull BlockPlaceEvent event) {
        super.onPlace(event);
        this.onPlaceInfoPanelBlock(event);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onBreak(@NotNull Location location) {
        super.onBreak(location);
        this.onBreakInfoPanelBlock(location);
    }

    @Override
    public void onTick10(@NotNull ConnectionGroup group, @NotNull Location location) {
        double charge;
        double initialCharge = charge = BlockStorageAPI.getDouble(location, "QP_CHARGE");
        charge = this.doCharge(location, charge);
        if (Utils.equal(initialCharge, charge = this.doDischarge(location, charge))) {
            return;
        }
        BlockStorageAPI.set(location, "QP_CHARGE", charge);
        this.doEmission(location, charge);
        this.updateConcreteTransformation(location);
        this.setPanelHidden(group, charge == 0.0);
        this.updatePanel(group);
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (this.doBurnoutCheck(group, "input")) {
            return;
        }
        Optional<Link> inputLink = Capacitor.getLink(location, "input");
        if (inputLink.isEmpty()) {
            BlockStorageAPI.set(location, "QP_CHARGE_RATE", 0);
            return;
        }
        double chargeRate = this.settings.isOperational(inputLink) ? PowerLossBlock.calculatePowerLoss(this.settings, inputLink.get().getPower() * 0.5) : 0.0;
        BlockStorageAPI.set(location, "QP_CHARGE_RATE", chargeRate);
    }

    private double doCharge(Location location, double charge) {
        double chargeRate = BlockStorageAPI.getDouble(location, "QP_CHARGE_RATE");
        return this.stepCharge(this.settings, charge, chargeRate);
    }

    private double doDischarge(Location location, double charge) {
        Optional<Link> outputLink = Capacitor.getLink(location, "output");
        if (outputLink.isEmpty()) {
            return charge;
        }
        double newCharge = this.stepDischarge(this.settings, charge);
        BlockStorageAPI.set(location, "QP_CHARGE", charge);
        return newCharge;
    }

    private void doEmission(Location location, double charge) {
        double outputPower;
        Optional<Link> outputLink = Capacitor.getLink(location, "output");
        if (outputLink.isEmpty()) {
            return;
        }
        Optional<Link> inputLink = Capacitor.getLink(location, "input");
        if (inputLink.isPresent() && charge == 0.0 && (outputPower = PowerLossBlock.calculatePowerLoss(this.settings, inputLink.get().getPower())) < this.getSettings().getOutputPower()) {
            outputLink.get().setPower(outputPower);
            return;
        }
        outputLink.get().setPowerFrequency(charge > this.settings.getOutputPower() * 0.5 ? this.settings.getOutputPower() : 0.0, 0.0);
    }

    @NotNull
    private Matrix4f getConcreteTransformationMatrix(double charge) {
        return new ModelDiamond().size(0.78f * (float)(charge / this.settings.getChargeCapacity())).getMatrix();
    }

    private void updateConcreteTransformation(Location location) {
        double charge = BlockStorageAPI.getDouble(location, "QP_CHARGE");
        Optional<Display> concreteDisplay = Capacitor.getDisplay(location, "concrete");
        concreteDisplay.ifPresent(display -> display.setTransformationMatrix(this.getConcreteTransformationMatrix(charge)));
    }
}

