/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.consumers;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelItem;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.blocks.consumers.CrystalRefiner;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;

public class IndustrialCrystalRefiner
extends CrystalRefiner {
    public static final Settings INDUSTRIAL_CRYSTAL_REFINER_SETTINGS = Settings.builder().tier(Tier.ADVANCED).timePerItem(10.0).minPower(1200.0).minFrequency(260.0).build();
    public static final SlimefunItemStack INDUSTRIAL_CRYSTAL_REFINER = new SlimefunItemStack("QP_INDUSTRIAL_CRYSTAL_REFINER", Material.QUARTZ_BLOCK, "&bIndustrial Crystal Refiner", Lore.create(CRYSTAL_REFINER_SETTINGS, "&7\u25cf Refines Phase Crystals", "&7\u25cf Can refine up to 16 items at once", "&7\u25cf &eRight Click &7with an item to start refining"));

    public IndustrialCrystalRefiner(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 1.1f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("wall1", new ModelCuboid().material(Material.WHITE_CONCRETE).location(0.3f, -0.21f, -0.3f).size(0.2f, 0.6f, 1.1f).rotation(0.7853981633974483)).add("wall2", new ModelCuboid().material(Material.WHITE_CONCRETE).location(-0.3f, -0.21f, 0.3f).size(0.2f, 0.6f, 1.1f).rotation(0.7853981633974483)).add("wall3", new ModelCuboid().material(Material.WHITE_CONCRETE).location(0.3f, -0.21f, 0.3f).size(1.1f, 0.6f, 0.2f).rotation(0.7853981633974483)).add("wall4", new ModelCuboid().material(Material.WHITE_CONCRETE).location(-0.3f, -0.21f, -0.3f).size(1.1f, 0.6f, 0.2f).rotation(0.7853981633974483)).add("panel1", new ModelCuboid().material(Material.RED_CONCRETE).brightness(3).location(0.4f, -0.21f, -0.4f).size(0.05f, 0.4f, 0.5f).rotation(0.7853981633974483)).add("panel2", new ModelCuboid().material(Material.RED_CONCRETE).brightness(3).location(-0.4f, -0.21f, 0.4f).size(0.05f, 0.4f, 0.5f).rotation(0.7853981633974483)).add("panel3", new ModelCuboid().material(Material.RED_CONCRETE).brightness(3).location(0.4f, -0.21f, 0.4f).size(0.5f, 0.4f, 0.05f).rotation(0.7853981633974483)).add("panel4", new ModelCuboid().material(Material.RED_CONCRETE).brightness(3).location(-0.4f, -0.21f, -0.4f).size(0.5f, 0.4f, 0.05f).rotation(0.7853981633974483)).add("water", new ModelCuboid().material(Material.BLUE_CONCRETE).location(0.0f, -0.3f, 0.0f).size(1.0f, 0.4f, 1.0f).rotation(0.7853981633974483)).add("concrete", new ModelCuboid().material(this.settings.getTier().concreteMaterial).brightness(3).location(0.0f, -0.2f, 0.0f).size(0.4f).rotation(0.7853981633974483)).add("item", new ModelItem().facing(player.getFacing()).size(0.5f).location(0.0f, 0.2f, 0.0f)).buildAtBlockCenter(location);
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "concrete", powered);
        this.brightnessAnimation(location, "panel1", powered);
        this.brightnessAnimation(location, "panel2", powered);
        this.brightnessAnimation(location, "panel3", powered);
        this.brightnessAnimation(location, "panel4", powered);
    }

    @Override
    public Map<ItemStack, ItemStack> getRecipes() {
        HashMap<ItemStack, ItemStack> recipes = new HashMap<ItemStack, ItemStack>();
        for (Map.Entry<ItemStack, ItemStack> recipe : super.getRecipes().entrySet()) {
            for (int i = 0; i < 16; ++i) {
                ItemStack input = recipe.getKey().clone();
                ItemStack output = recipe.getValue().clone();
                input.add(i);
                output.add(i);
                recipes.put(input, output);
            }
        }
        return recipes;
    }
}

