/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.connections;

import java.util.Optional;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.metamechanists.quaptics.beams.FrequencyColor;
import org.metamechanists.quaptics.beams.beam.DirectBeam;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.displaymodellib.builders.InteractionBuilder;
import org.metamechanists.quaptics.schedulers.BlockUpdateScheduler;
import org.metamechanists.quaptics.storage.PersistentDataTraverser;
import org.metamechanists.quaptics.utils.Utils;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;
import org.metamechanists.quaptics.utils.id.complex.DirectBeamId;
import org.metamechanists.quaptics.utils.id.complex.LinkId;

public class Link {
    private static final int ARBITRARILY_LARGE_NUMBER = 9999999;
    private static final double MAX_POWER_CHANGE_PROPORTION = 1.0E-4;
    private static final double MAX_FREQUENCY_CHANGE_PROPORTION = 1.0E-4;
    private static final float MIN_BEAM_SIZE = 0.001f;
    private static final float MAX_BEAM_SIZE = 0.05f;
    private final LinkId id;
    private final ConnectionPointId outputId;
    private final ConnectionPointId inputId;
    private final Location outputLocation;
    private final Location inputLocation;
    private final double maxPower;
    @Nullable
    private DirectBeamId directBeamId;
    private double power;
    private double frequency;
    private int phase;

    public Link(ConnectionPointId inputId, ConnectionPointId outputId) {
        this.inputId = inputId;
        this.outputId = outputId;
        ConnectionPoint input = this.getInput().get();
        ConnectionPoint output = this.getOutput().get();
        this.inputLocation = input.getLocation().get();
        this.outputLocation = output.getLocation().get();
        this.id = new LinkId(new InteractionBuilder().height(0.0f).width(0.0f).build(this.inputLocation).getUniqueId());
        this.maxPower = input.getGroup().get().getBlock().getSettings().getTier().maxPower;
        this.saveData();
        input.link(this.id);
        output.link(this.id);
        Link.updateGroup(input);
        Link.updateGroup(output);
        this.regenerateBeam();
        this.saveData();
        this.getOutput().flatMap(ConnectionPoint::getGroup).ifPresent(ConnectionGroup::updatePanels);
        this.getInput().flatMap(ConnectionPoint::getGroup).ifPresent(ConnectionGroup::updatePanels);
    }

    public Link(LinkId id) {
        PersistentDataTraverser traverser = new PersistentDataTraverser(id);
        this.id = id;
        this.outputId = traverser.getConnectionPointId("outputId");
        this.inputId = traverser.getConnectionPointId("inputId");
        this.directBeamId = traverser.getBeamId("beamId");
        this.power = traverser.getDouble("power");
        this.frequency = traverser.getDouble("frequency");
        this.phase = traverser.getInt("phase");
        this.maxPower = traverser.getDouble("maxPower");
        this.inputLocation = this.getInput().get().getLocation().get();
        this.outputLocation = this.getOutput().get().getLocation().get();
    }

    private void saveData() {
        PersistentDataTraverser traverser = new PersistentDataTraverser(this.id);
        traverser.set("outputId", this.outputId);
        traverser.set("inputId", this.inputId);
        traverser.set("beamId", this.directBeamId);
        traverser.set("power", this.power);
        traverser.set("frequency", this.frequency);
        traverser.set("phase", this.phase);
        traverser.set("maxPower", this.maxPower);
    }

    public Optional<ConnectionPoint> getOutput() {
        return ((Optional)this.outputId.get()).isEmpty() || !((ConnectionPoint)((Optional)this.outputId.get()).get()).isOutput() ? Optional.empty() : Optional.of((ConnectionPoint)((Optional)this.outputId.get()).get());
    }

    public Optional<ConnectionPoint> getInput() {
        return ((Optional)this.inputId.get()).isEmpty() || !((ConnectionPoint)((Optional)this.inputId.get()).get()).isInput() ? Optional.empty() : Optional.of((ConnectionPoint)((Optional)this.inputId.get()).get());
    }

    public void remove() {
        if (this.hasBeam()) {
            this.getBeam().ifPresent(DirectBeam::deprecate);
            this.directBeamId = null;
        }
        this.getOutput().ifPresent(output -> {
            output.unlink();
            Link.updateGroup(output);
        });
        this.getInput().ifPresent(input -> {
            input.unlink();
            Link.updateGroup(input);
        });
    }

    private boolean hasBeam() {
        return this.directBeamId != null;
    }

    private Optional<DirectBeam> getBeam() {
        return Optional.ofNullable(this.directBeamId).map(DirectBeam::new);
    }

    private void regenerateBeam() {
        this.getBeam().ifPresent(DirectBeam::deprecate);
        this.directBeamId = new DirectBeam(FrequencyColor.getMaterial(this.frequency), this.outputLocation, this.inputLocation, this.calculateRadius(), this.calculateRoll()).getId();
    }

    private void updateBeam() {
        Optional<DirectBeam> beam = this.getBeam();
        if (beam.isEmpty()) {
            return;
        }
        beam.get().setMaterial(FrequencyColor.getMaterial(this.frequency));
        beam.get().setThicknessAndRoll(this.outputLocation, this.inputLocation, this.calculateRadius(), this.calculateRoll());
    }

    private void updatePanels() {
        this.getOutput().flatMap(ConnectionPoint::getGroup).ifPresent(ConnectionGroup::updatePanels);
        this.getInput().flatMap(ConnectionPoint::getGroup).ifPresent(ConnectionGroup::updatePanels);
    }

    private static void updateGroup(@NotNull ConnectionPoint point) {
        point.getGroup().ifPresent(group -> BlockUpdateScheduler.scheduleUpdate(group.getId()));
    }

    private float calculateRadius() {
        if (this.power == 0.0) {
            return 0.0f;
        }
        return Utils.clampToRange((float)(this.power / this.maxPower) * 0.05f, 0.001f, 0.05f);
    }

    private double calculateRoll() {
        return this.phase != 0 ? 1.5707963267948966 : 0.0;
    }

    private static double calculateChange(double initialValue, double newValue) {
        if (initialValue == 0.0) {
            return newValue == 0.0 ? 0.0 : 9999999.0;
        }
        return Math.abs((newValue - initialValue) / initialValue);
    }

    public void setPower(double power) {
        if (Link.calculateChange(this.power, power) < 1.0E-4) {
            return;
        }
        this.power = power;
        this.saveData();
        this.updateBeam();
        this.updatePanels();
        this.getInput().ifPresent(Link::updateGroup);
    }

    private void setFrequency(double frequency) {
        if (Link.calculateChange(this.frequency, frequency) < 1.0E-4) {
            return;
        }
        this.frequency = frequency;
        this.saveData();
        this.updateBeam();
        this.updatePanels();
        this.getInput().ifPresent(Link::updateGroup);
    }

    private void setPhase(int phase) {
        int newPhase = phase;
        if (newPhase > 360) {
            newPhase -= 360;
        }
        if (this.phase == newPhase) {
            return;
        }
        this.phase = newPhase;
        this.saveData();
        this.updateBeam();
        this.updatePanels();
        this.getInput().ifPresent(Link::updateGroup);
    }

    public void setPowerFrequency(double power, double frequency) {
        this.setPower(power);
        this.setFrequency(frequency);
    }

    public void setPowerFrequencyPhase(double power, double frequency, int phase) {
        this.setPower(power);
        this.setFrequency(frequency);
        this.setPhase(phase);
    }

    public boolean isEnabled() {
        return this.power != 0.0;
    }

    public void disable() {
        this.setPowerFrequencyPhase(0.0, 0.0, 0);
    }

    public LinkId getId() {
        return this.id;
    }

    public double getPower() {
        return this.power;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public int getPhase() {
        return this.phase;
    }
}

