/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.beams.beam;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.joml.Vector3f;
import org.metamechanists.quaptics.beams.DeprecatedBeamStorage;
import org.metamechanists.quaptics.beams.beam.Beam;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelLine;
import org.metamechanists.quaptics.displaymodellib.transformations.TransformationUtils;
import org.metamechanists.quaptics.utils.id.simple.BlockDisplayId;

public class ProjectileBeam
implements Beam {
    private final Player player;
    private final Vector velocity;
    private final BlockDisplayId displayId;
    private final float thickness;
    private final double damage;
    private final int lifetimeTicks;
    private int ageTicks;

    public ProjectileBeam(Player player, Material material, Location source, Location target, float thickness, float length, float speed, double damage, int lifetimeTicks) {
        this.player = player;
        this.velocity = Vector.fromJOML((Vector3f)TransformationUtils.getDisplacement(source, target).normalize().mul(speed));
        this.displayId = new BlockDisplayId(new ModelLine().to(TransformationUtils.getDirection(source, target).mul(length)).thickness(thickness).brightness(15).material(material).build(source).getUniqueId());
        this.thickness = thickness;
        this.damage = damage;
        this.lifetimeTicks = lifetimeTicks;
    }

    private Optional<BlockDisplay> getDisplay() {
        return this.displayId.get();
    }

    @Override
    public void tick() {
        this.getDisplay().ifPresent(display -> {
            display.teleport(display.getLocation().add(this.velocity));
            List nearbyEntities = display.getNearbyEntities((double)this.thickness, (double)this.thickness, (double)this.thickness);
            if (nearbyEntities.isEmpty()) {
                return;
            }
            Optional<Damageable> hitEntity = nearbyEntities.stream().filter(Damageable.class::isInstance).map(Damageable.class::cast).findFirst();
            hitEntity.ifPresent(entity -> {
                if (Slimefun.getProtectionManager().hasPermission((OfflinePlayer)this.player, entity.getLocation(), Interaction.ATTACK_ENTITY)) {
                    entity.damage(this.damage);
                    entity.setVelocity(this.velocity.clone().normalize().multiply(0.2));
                }
                DeprecatedBeamStorage.remove(this);
            });
        });
        ++this.ageTicks;
    }

    @Override
    public void remove() {
        this.getDisplay().ifPresent(Entity::remove);
    }

    @Override
    public boolean expired() {
        return this.ageTicks > this.lifetimeTicks;
    }
}

