/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.utils;

import io.github.sefiraat.networks.network.stackcaches.ItemStackCache;
import io.github.sefiraat.networks.utils.Keys;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.AxolotlBucketMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.persistence.PersistentDataHolder;

public final class StackUtils {
    @Nonnull
    public static ItemStack getAsQuantity(@Nonnull ItemStack itemStack, int amount) {
        ItemStack clone = itemStack.clone();
        clone.setAmount(amount);
        return clone;
    }

    public static boolean itemsMatch(@Nullable ItemStack itemStack1, @Nullable ItemStack itemStack2) {
        return StackUtils.itemsMatch(new ItemStackCache(itemStack1), itemStack2, true);
    }

    public static boolean itemsMatch(@Nonnull ItemStackCache cache, @Nullable ItemStack itemStack, boolean checkLore) {
        if (cache.getItemStack() == null || itemStack == null) {
            return itemStack == null && cache.getItemStack() == null;
        }
        if (itemStack.getType() != cache.getItemType()) {
            return false;
        }
        if (!itemStack.hasItemMeta() || !cache.getItemStack().hasItemMeta()) {
            return itemStack.hasItemMeta() == cache.getItemStack().hasItemMeta();
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemMeta cachedMeta = cache.getItemMeta();
        if (!itemMeta.getClass().equals(cachedMeta.getClass())) {
            return false;
        }
        if (StackUtils.canQuickEscapeMetaVariant(itemMeta, cachedMeta)) {
            return false;
        }
        if (itemMeta.hasDisplayName() != cachedMeta.hasDisplayName()) {
            return false;
        }
        boolean hasCustomOne = itemMeta.hasCustomModelData();
        boolean hasCustomTwo = cachedMeta.hasCustomModelData();
        if (hasCustomOne ? !hasCustomTwo || itemMeta.getCustomModelData() != cachedMeta.getCustomModelData() : hasCustomTwo) {
            return false;
        }
        if (!itemMeta.getPersistentDataContainer().equals(cachedMeta.getPersistentDataContainer())) {
            return false;
        }
        if (!itemMeta.getEnchants().equals(cachedMeta.getEnchants())) {
            return false;
        }
        if (!itemMeta.getItemFlags().equals(cachedMeta.getItemFlags())) {
            return false;
        }
        if (checkLore && !Objects.equals(itemMeta.getLore(), cachedMeta.getLore())) {
            return false;
        }
        Optional optionalStackId1 = Slimefun.getItemDataService().getItemData(itemMeta);
        Optional optionalStackId2 = Slimefun.getItemDataService().getItemData(cachedMeta);
        if (optionalStackId1.isPresent() && optionalStackId2.isPresent()) {
            return ((String)optionalStackId1.get()).equals(optionalStackId2.get());
        }
        return !itemMeta.hasDisplayName() || itemMeta.getDisplayName().equals(cachedMeta.getDisplayName());
    }

    public static boolean canQuickEscapeMetaVariant(@Nonnull ItemMeta metaOne, @Nonnull ItemMeta metaTwo) {
        BookMeta instanceTwo;
        BookMeta instanceOne;
        Damageable instanceTwo2;
        Damageable instanceOne2;
        ItemMeta itemMeta = metaOne;
        if (itemMeta instanceof Damageable) {
            instanceOne2 = (Damageable)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof Damageable) {
                instanceTwo2 = (Damageable)itemMeta;
                if (instanceOne2.getDamage() != instanceTwo2.getDamage()) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof AxolotlBucketMeta) {
            instanceOne2 = (AxolotlBucketMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof AxolotlBucketMeta) {
                instanceTwo2 = (AxolotlBucketMeta)itemMeta;
                if (instanceOne2.hasVariant() != instanceTwo2.hasVariant()) {
                    return true;
                }
                if (!instanceOne2.hasVariant() || !instanceTwo2.hasVariant()) {
                    return true;
                }
                if (instanceOne2.getVariant() != instanceTwo2.getVariant()) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof BannerMeta) {
            instanceOne2 = (BannerMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof BannerMeta) {
                instanceTwo2 = (BannerMeta)itemMeta;
                if (!instanceOne2.getPatterns().equals(instanceTwo2.getPatterns())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof BookMeta) {
            instanceOne = (BookMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof BookMeta) {
                instanceTwo = (BookMeta)itemMeta;
                if (instanceOne.getPageCount() != instanceTwo.getPageCount()) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getAuthor(), instanceTwo.getAuthor())) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getTitle(), instanceTwo.getTitle())) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getGeneration(), instanceTwo.getGeneration())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof BundleMeta) {
            instanceOne2 = (BundleMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof BundleMeta) {
                instanceTwo2 = (BundleMeta)itemMeta;
                if (instanceOne2.hasItems() != instanceTwo2.hasItems()) {
                    return true;
                }
                if (!instanceOne2.getItems().equals(instanceTwo2.getItems())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof CompassMeta) {
            instanceOne = (CompassMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof CompassMeta) {
                instanceTwo = (CompassMeta)itemMeta;
                if (instanceOne.isLodestoneTracked() != instanceTwo.isLodestoneTracked()) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getLodestone(), instanceTwo.getLodestone())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof CrossbowMeta) {
            instanceOne = (CrossbowMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof CrossbowMeta) {
                instanceTwo = (CrossbowMeta)itemMeta;
                if (instanceOne.hasChargedProjectiles() != instanceTwo.hasChargedProjectiles()) {
                    return true;
                }
                if (!instanceOne.getChargedProjectiles().equals(instanceTwo.getChargedProjectiles())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof EnchantmentStorageMeta) {
            instanceOne2 = (EnchantmentStorageMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof EnchantmentStorageMeta) {
                instanceTwo2 = (EnchantmentStorageMeta)itemMeta;
                if (instanceOne2.hasStoredEnchants() != instanceTwo2.hasStoredEnchants()) {
                    return true;
                }
                if (!instanceOne2.getStoredEnchants().equals(instanceTwo2.getStoredEnchants())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof FireworkEffectMeta) {
            instanceOne2 = (FireworkEffectMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof FireworkEffectMeta) {
                instanceTwo2 = (FireworkEffectMeta)itemMeta;
                if (!Objects.equals(instanceOne2.getEffect(), instanceTwo2.getEffect())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof FireworkMeta) {
            instanceOne2 = (FireworkMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof FireworkMeta) {
                instanceTwo2 = (FireworkMeta)itemMeta;
                if (instanceOne2.getPower() != instanceTwo2.getPower()) {
                    return true;
                }
                if (!instanceOne2.getEffects().equals(instanceTwo2.getEffects())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof LeatherArmorMeta) {
            instanceOne = (LeatherArmorMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof LeatherArmorMeta) {
                instanceTwo = (LeatherArmorMeta)itemMeta;
                if (!instanceOne.getColor().equals((Object)instanceTwo.getColor())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof MapMeta) {
            instanceOne2 = (MapMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof MapMeta) {
                instanceTwo2 = (MapMeta)itemMeta;
                if (instanceOne2.hasMapView() != instanceTwo2.hasMapView()) {
                    return true;
                }
                if (instanceOne2.hasLocationName() != instanceTwo2.hasLocationName()) {
                    return true;
                }
                if (instanceOne2.hasColor() != instanceTwo2.hasColor()) {
                    return true;
                }
                if (!Objects.equals(instanceOne2.getMapView(), instanceTwo2.getMapView())) {
                    return true;
                }
                if (!Objects.equals(instanceOne2.getLocationName(), instanceTwo2.getLocationName())) {
                    return true;
                }
                if (!Objects.equals(instanceOne2.getColor(), instanceTwo2.getColor())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof PotionMeta) {
            instanceOne = (PotionMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof PotionMeta) {
                instanceTwo = (PotionMeta)itemMeta;
                if (!instanceOne.getBasePotionData().equals((Object)instanceTwo.getBasePotionData())) {
                    return true;
                }
                if (instanceOne.hasCustomEffects() != instanceTwo.hasCustomEffects()) {
                    return true;
                }
                if (instanceOne.hasColor() != instanceTwo.hasColor()) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getColor(), instanceTwo.getColor())) {
                    return true;
                }
                if (!instanceOne.getCustomEffects().equals(instanceTwo.getCustomEffects())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof SkullMeta) {
            instanceOne2 = (SkullMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof SkullMeta) {
                instanceTwo2 = (SkullMeta)itemMeta;
                if (instanceOne2.hasOwner() != instanceTwo2.hasOwner()) {
                    return true;
                }
                if (!Objects.equals(instanceOne2.getOwningPlayer(), instanceTwo2.getOwningPlayer())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof SuspiciousStewMeta) {
            instanceOne2 = (SuspiciousStewMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof SuspiciousStewMeta) {
                instanceTwo2 = (SuspiciousStewMeta)itemMeta;
                if (!Objects.equals(instanceOne2.getCustomEffects(), instanceTwo2.getCustomEffects())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof TropicalFishBucketMeta) {
            instanceOne = (TropicalFishBucketMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof TropicalFishBucketMeta) {
                instanceTwo = (TropicalFishBucketMeta)itemMeta;
                if (instanceOne.hasVariant() != instanceTwo.hasVariant()) {
                    return true;
                }
                if (!instanceOne.getPattern().equals((Object)instanceTwo.getPattern())) {
                    return true;
                }
                if (!instanceOne.getBodyColor().equals((Object)instanceTwo.getBodyColor())) {
                    return true;
                }
                if (!instanceOne.getPatternColor().equals((Object)instanceTwo.getPatternColor())) {
                    return true;
                }
            }
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public static void putOnCooldown(ItemStack itemStack, int durationInSeconds) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            PersistentDataAPI.setLong((PersistentDataHolder)itemMeta, (NamespacedKey)Keys.ON_COOLDOWN, (long)(System.currentTimeMillis() + (long)durationInSeconds * 1000L));
            itemStack.setItemMeta(itemMeta);
        }
    }

    @ParametersAreNonnullByDefault
    public static boolean isOnCooldown(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            long cooldownUntil = PersistentDataAPI.getLong((PersistentDataHolder)itemMeta, (NamespacedKey)Keys.ON_COOLDOWN, (long)0L);
            return System.currentTimeMillis() < cooldownUntil;
        }
        return false;
    }

    @Generated
    private StackUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

