/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.Networks;
import io.github.sefiraat.networks.utils.Theme;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public interface AdminDebuggable {
    public static final String DEBUG_KEY = "network_debugging";

    default public boolean isDebug(@Nonnull Location location) {
        String debug = BlockStorage.getLocationInfo((Location)location, (String)DEBUG_KEY);
        return Boolean.parseBoolean(debug);
    }

    default public void setDebug(@Nonnull Location location, boolean value) {
        BlockStorage.addBlockInfo((Location)location, (String)DEBUG_KEY, (String)String.valueOf(value));
    }

    default public void toggle(@Nonnull Location location, @Nonnull Player player) {
        boolean isDebug = this.isDebug(location);
        boolean nextState = !isDebug;
        this.setDebug(location, nextState);
        player.sendMessage(Theme.SUCCESS + "Debugging for this block has been set to: " + nextState + ".");
        if (nextState) {
            player.sendMessage(Theme.SUCCESS + "It will last until a restart or you toggle it off.");
        }
    }

    default public void sendDebugMessage(@Nonnull Location location, @Nonnull String string) {
        if (this.isDebug(location)) {
            String locationString = "W[" + location.getWorld().getName() + "] X[" + location.getBlockX() + "] Y[" + location.getBlockY() + "] Z[" + location.getBlockZ() + "] ";
            Networks.getInstance().getJavaPlugin().getLogger().log(Level.INFO, locationString + " - " + string);
        }
    }
}

