/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.utils.datatypes;

import de.jeff_media.morepersistentdatatypes.DataType;
import io.github.sefiraat.networks.network.stackcaches.QuantumCache;
import io.github.sefiraat.networks.utils.Keys;
import javax.annotation.Nonnull;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PersistentQuantumStorageType
implements PersistentDataType<PersistentDataContainer, QuantumCache> {
    public static final PersistentDataType<PersistentDataContainer, QuantumCache> TYPE = new PersistentQuantumStorageType();
    public static final NamespacedKey ITEM = Keys.newKey("item");
    public static final NamespacedKey AMOUNT = Keys.newKey("amount");
    public static final NamespacedKey MAX_AMOUNT = Keys.newKey("max_amount");
    public static final NamespacedKey VOID = Keys.newKey("void");

    @Nonnull
    public Class<PersistentDataContainer> getPrimitiveType() {
        return PersistentDataContainer.class;
    }

    @Nonnull
    public Class<QuantumCache> getComplexType() {
        return QuantumCache.class;
    }

    @Nonnull
    public PersistentDataContainer toPrimitive(@Nonnull QuantumCache complex, @Nonnull PersistentDataAdapterContext context) {
        PersistentDataContainer container = context.newPersistentDataContainer();
        container.set(ITEM, DataType.ITEM_STACK, (Object)complex.getItemStack());
        container.set(AMOUNT, DataType.INTEGER, (Object)complex.getAmount());
        container.set(MAX_AMOUNT, DataType.INTEGER, (Object)complex.getLimit());
        container.set(VOID, DataType.BOOLEAN, (Object)complex.isVoidExcess());
        return container;
    }

    @Nonnull
    public QuantumCache fromPrimitive(@Nonnull PersistentDataContainer primitive, @Nonnull PersistentDataAdapterContext context) {
        ItemStack item = (ItemStack)primitive.get(ITEM, DataType.ITEM_STACK);
        int amount = (Integer)primitive.get(AMOUNT, DataType.INTEGER);
        int limit = (Integer)primitive.get(MAX_AMOUNT, DataType.INTEGER);
        boolean voidExcess = (Boolean)primitive.get(VOID, DataType.BOOLEAN);
        return new QuantumCache(item, amount, limit, voidExcess);
    }
}

