/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.network.stackcaches.QuantumCache;
import io.github.sefiraat.networks.utils.Keys;
import io.github.sefiraat.networks.utils.StackUtils;
import io.github.sefiraat.networks.utils.StringUtils;
import io.github.sefiraat.networks.utils.Theme;
import io.github.sefiraat.networks.utils.datatypes.DataTypeMethods;
import io.github.sefiraat.networks.utils.datatypes.PersistentQuantumStorageType;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.DistinctiveItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class NetworkQuantumStorage
extends SlimefunItem
implements DistinctiveItem {
    private static final int[] SIZES = new int[]{4096, 32768, 262144, 0x200000, 0x1000000, 0x8000000, 0x40000000, Integer.MAX_VALUE};
    public static final String BS_AMOUNT = "stored_amount";
    public static final String BS_VOID = "void_excess";
    public static final int INPUT_SLOT = 1;
    public static final int ITEM_SLOT = 4;
    public static final int ITEM_SET_SLOT = 13;
    public static final int OUTPUT_SLOT = 7;
    private static final ItemStack BACK_INPUT = new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, Theme.PASSIVE + "Input", new String[0]);
    private static final ItemStack BACK_ITEM = new CustomItemStack(Material.BLUE_STAINED_GLASS_PANE, Theme.PASSIVE + "Item Stored", new String[0]);
    private static final ItemStack NO_ITEM = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, Theme.ERROR + "No Registered Item", new String[]{Theme.PASSIVE + "Click the icon below while", Theme.PASSIVE + "holding an item to register it."});
    private static final ItemStack SET_ITEM = new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, Theme.SUCCESS + "Set Item", new String[]{Theme.PASSIVE + "Drag an item on top of this pane to register it.", Theme.PASSIVE + "Shift Click to change voiding"});
    private static final ItemStack BACK_OUTPUT = new CustomItemStack(Material.ORANGE_STAINED_GLASS_PANE, Theme.PASSIVE + "Output", new String[0]);
    private static final int[] INPUT_SLOTS = new int[]{0, 2};
    private static final int[] ITEM_SLOTS = new int[]{3, 5};
    private static final int[] OUTPUT_SLOTS = new int[]{6, 8};
    private static final int[] BACKGROUND_SLOTS = new int[]{9, 10, 11, 12, 14, 15, 16, 17};
    private static final Map<Location, QuantumCache> CACHES = new HashMap<Location, QuantumCache>();
    private final List<Integer> slotsToDrop = new ArrayList<Integer>();
    private final int maxAmount;

    public NetworkQuantumStorage(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int maxAmount) {
        super(itemGroup, item, recipeType, recipe);
        this.maxAmount = maxAmount;
        this.slotsToDrop.add(1);
        this.slotsToDrop.add(7);
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block b, SlimefunItem item, Config data) {
                NetworkQuantumStorage.this.onTick(b);
            }
        }, new BlockBreakHandler(false, false){

            @ParametersAreNonnullByDefault
            public void onPlayerBreak(BlockBreakEvent event, ItemStack item, List<ItemStack> drops) {
                NetworkQuantumStorage.this.onBreak(event);
            }
        }, new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent event) {
                NetworkQuantumStorage.this.onPlace(event);
            }
        }});
    }

    private void onTick(Block block) {
        ItemStack input;
        BlockMenu blockMenu = BlockStorage.getInventory((Block)block);
        if (blockMenu == null) {
            CACHES.remove(block.getLocation());
            return;
        }
        QuantumCache cache = CACHES.get(blockMenu.getLocation());
        if (cache == null) {
            return;
        }
        if (blockMenu.hasViewer()) {
            NetworkQuantumStorage.updateDisplayItem(blockMenu, cache);
        }
        if ((input = blockMenu.getItemInSlot(1)) != null && input.getType() != Material.AIR) {
            NetworkQuantumStorage.tryInputItem(blockMenu.getLocation(), new ItemStack[]{input}, cache);
        }
        ItemStack output = blockMenu.getItemInSlot(7);
        ItemStack fetched = null;
        if (output == null || output.getType() == Material.AIR) {
            fetched = cache.withdrawItem();
        } else if (StackUtils.itemsMatch(cache, output, true) && output.getAmount() < output.getMaxStackSize()) {
            int requestAmount = output.getMaxStackSize() - output.getAmount();
            fetched = cache.withdrawItem(requestAmount);
        }
        if (fetched != null && fetched.getType() != Material.AIR) {
            blockMenu.pushItem(fetched, new int[]{7});
            NetworkQuantumStorage.syncBlock(blockMenu.getLocation(), cache);
        }
        CACHES.put(blockMenu.getLocation().clone(), cache);
    }

    private void toggleVoid(@Nonnull BlockMenu blockMenu) {
        QuantumCache cache;
        cache.setVoidExcess(!(cache = CACHES.get(blockMenu.getLocation())).isVoidExcess());
        NetworkQuantumStorage.updateDisplayItem(blockMenu, cache);
        NetworkQuantumStorage.syncBlock(blockMenu.getLocation(), cache);
        CACHES.put(blockMenu.getLocation(), cache);
    }

    private void setItem(@Nonnull BlockMenu blockMenu, @Nonnull Player player) {
        ItemStack itemStack = player.getItemOnCursor().clone();
        if (NetworkQuantumStorage.isBlacklisted(itemStack)) {
            return;
        }
        QuantumCache cache = CACHES.get(blockMenu.getLocation());
        if (cache == null || cache.getAmount() > 0) {
            player.sendMessage(Theme.WARNING + "Quantum Storage must be empty before changing the set item.");
            return;
        }
        itemStack.setAmount(1);
        cache.setItemStack(itemStack);
        NetworkQuantumStorage.updateDisplayItem(blockMenu, cache);
        NetworkQuantumStorage.syncBlock(blockMenu.getLocation(), cache);
        CACHES.put(blockMenu.getLocation(), cache);
    }

    public void postRegister() {
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                for (int i : INPUT_SLOTS) {
                    this.addItem(i, BACK_INPUT, (p, slot, item, action) -> false);
                }
                for (int i : ITEM_SLOTS) {
                    this.addItem(i, BACK_ITEM, (p, slot, item, action) -> false);
                }
                for (int i : OUTPUT_SLOTS) {
                    this.addItem(i, BACK_OUTPUT, (p, slot, item, action) -> false);
                }
                this.addItem(13, SET_ITEM, (p, slot, item, action) -> false);
                this.addMenuClickHandler(4, ChestMenuUtils.getEmptyClickHandler());
                this.drawBackground(BACKGROUND_SLOTS);
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return new int[]{1};
                }
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return new int[]{7};
                }
                return new int[0];
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block block) {
                menu.addMenuClickHandler(13, (p, slot, item, action) -> {
                    if (action.isShiftClicked()) {
                        NetworkQuantumStorage.this.toggleVoid(menu);
                    } else {
                        NetworkQuantumStorage.this.setItem(menu, p);
                    }
                    return false;
                });
                QuantumCache cache = CACHES.get(block.getLocation());
                if (cache == null) {
                    cache = NetworkQuantumStorage.this.addCache(menu);
                }
                NetworkQuantumStorage.updateDisplayItem(menu, cache);
            }
        };
    }

    private QuantumCache addCache(@Nonnull BlockMenu blockMenu) {
        Location location = blockMenu.getLocation();
        String amountString = BlockStorage.getLocationInfo((Location)location, (String)BS_AMOUNT);
        String voidString = BlockStorage.getLocationInfo((Location)location, (String)BS_VOID);
        int amount = amountString == null ? 0 : Integer.parseInt(amountString);
        boolean voidExcess = voidString == null || Boolean.parseBoolean(voidString);
        ItemStack itemStack = blockMenu.getItemInSlot(4);
        QuantumCache cache = this.createCache(itemStack, blockMenu, amount, voidExcess);
        CACHES.put(location, cache);
        return cache;
    }

    private QuantumCache createCache(@Nullable ItemStack itemStack, @Nonnull BlockMenu menu, int amount, boolean voidExcess) {
        if (itemStack == null || itemStack.getType() == Material.AIR || this.isDisplayItem(itemStack)) {
            menu.addItem(4, NO_ITEM);
            return new QuantumCache(null, 0, this.maxAmount, true);
        }
        ItemStack clone = itemStack.clone();
        ItemMeta itemMeta = clone.getItemMeta();
        List lore = itemMeta.getLore();
        for (int i = 0; i < 3; ++i) {
            lore.remove(lore.size() - 1);
        }
        itemMeta.setLore(lore.isEmpty() ? null : lore);
        clone.setItemMeta(itemMeta);
        QuantumCache cache = new QuantumCache(clone, amount, this.maxAmount, voidExcess);
        NetworkQuantumStorage.updateDisplayItem(menu, cache);
        return cache;
    }

    private boolean isDisplayItem(@Nonnull ItemStack itemStack) {
        return PersistentDataAPI.getBoolean((PersistentDataHolder)itemStack.getItemMeta(), (NamespacedKey)Keys.newKey("display"));
    }

    protected void onBreak(@Nonnull BlockBreakEvent event) {
        Location location = event.getBlock().getLocation();
        BlockMenu blockMenu = BlockStorage.getInventory((Block)event.getBlock());
        if (blockMenu != null) {
            QuantumCache cache = CACHES.remove(blockMenu.getLocation());
            if (cache != null && cache.getAmount() > 0 && cache.getItemStack() != null) {
                ItemStack itemToDrop = this.getItem().clone();
                ItemMeta itemMeta = itemToDrop.getItemMeta();
                DataTypeMethods.setCustom((PersistentDataHolder)itemMeta, Keys.QUANTUM_STORAGE_INSTANCE, PersistentQuantumStorageType.TYPE, cache);
                cache.addMetaLore(itemMeta);
                itemToDrop.setItemMeta(itemMeta);
                location.getWorld().dropItem(location.clone().add(0.5, 0.5, 0.5), itemToDrop);
                event.setDropItems(false);
            }
            for (int i : this.slotsToDrop) {
                blockMenu.dropItems(location, new int[]{i});
            }
        }
    }

    protected void onPlace(@Nonnull BlockPlaceEvent event) {
        ItemStack itemStack = event.getItemInHand();
        ItemMeta itemMeta = itemStack.getItemMeta();
        QuantumCache cache = DataTypeMethods.getCustom((PersistentDataHolder)itemMeta, Keys.QUANTUM_STORAGE_INSTANCE, PersistentQuantumStorageType.TYPE);
        if (cache == null) {
            return;
        }
        NetworkQuantumStorage.syncBlock(event.getBlock().getLocation(), cache);
        CACHES.put(event.getBlock().getLocation(), cache);
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    @ParametersAreNonnullByDefault
    public static void tryInputItem(Location location, ItemStack[] input, QuantumCache cache) {
        if (cache.getItemStack() == null) {
            return;
        }
        for (ItemStack itemStack : input) {
            if (NetworkQuantumStorage.isBlacklisted(itemStack) || !StackUtils.itemsMatch(cache, itemStack, true)) continue;
            int leftover = cache.increaseAmount(itemStack.getAmount());
            itemStack.setAmount(leftover);
        }
        NetworkQuantumStorage.syncBlock(location, cache);
    }

    private static boolean isBlacklisted(@Nonnull ItemStack itemStack) {
        return itemStack.getType() == Material.AIR || itemStack.getType().getMaxDurability() < 0 || Tag.SHULKER_BOXES.isTagged((Keyed)itemStack.getType()) || SlimefunItem.getByItem((ItemStack)itemStack) instanceof NetworkQuantumStorage;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public static ItemStack getItemStack(@Nonnull QuantumCache cache, @Nonnull BlockMenu blockMenu) {
        if (cache.getItemStack() == null || cache.getAmount() <= 0) {
            return null;
        }
        return NetworkQuantumStorage.getItemStack(cache, blockMenu, cache.getItemStack().getMaxStackSize());
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public static ItemStack getItemStack(@Nonnull QuantumCache cache, @Nonnull BlockMenu blockMenu, int amount) {
        if (cache.getAmount() < amount) {
            ItemStack output = blockMenu.getItemInSlot(7);
            ItemStack fetched = cache.withdrawItem(amount);
            if (output != null && output.getType() != Material.AIR && StackUtils.itemsMatch(cache, output, true)) {
                if (fetched == null || fetched.getType() == Material.AIR) {
                    fetched = output.clone();
                    if (fetched.getAmount() > amount) {
                        fetched.setAmount(amount);
                    }
                    output.setAmount(output.getAmount() - fetched.getAmount());
                } else {
                    int additional = Math.min(amount - fetched.getAmount(), output.getAmount());
                    output.setAmount(output.getAmount() - additional);
                    fetched.setAmount(fetched.getAmount() + additional);
                }
            }
            NetworkQuantumStorage.syncBlock(blockMenu.getLocation(), cache);
            return fetched;
        }
        NetworkQuantumStorage.syncBlock(blockMenu.getLocation(), cache);
        return cache.withdrawItem(amount);
    }

    private static void updateDisplayItem(@Nonnull BlockMenu menu, @Nonnull QuantumCache cache) {
        if (cache.getItemStack() == null) {
            menu.replaceExistingItem(4, NO_ITEM);
        } else {
            ItemStack itemStack = cache.getItemStack().clone();
            ItemMeta itemMeta = itemStack.getItemMeta();
            List lore = itemMeta.hasLore() ? itemMeta.getLore() : new ArrayList();
            lore.add("");
            lore.add(Theme.CLICK_INFO + "Voiding: " + Theme.PASSIVE + StringUtils.toTitleCase(String.valueOf(cache.isVoidExcess())));
            lore.add(Theme.CLICK_INFO + "Amount: " + Theme.PASSIVE + cache.getAmount());
            itemMeta.setLore(lore);
            itemStack.setItemMeta(itemMeta);
            itemStack.setAmount(1);
            menu.replaceExistingItem(4, itemStack);
        }
    }

    private static void syncBlock(@Nonnull Location location, @Nonnull QuantumCache cache) {
        BlockStorage.addBlockInfo((Location)location, (String)BS_AMOUNT, (String)String.valueOf(cache.getAmount()));
        BlockStorage.addBlockInfo((Location)location, (String)BS_VOID, (String)String.valueOf(cache.isVoidExcess()));
    }

    public static Map<Location, QuantumCache> getCaches() {
        return CACHES;
    }

    public static int[] getSizes() {
        return SIZES;
    }

    public boolean canStack(@Nonnull ItemMeta sfItemMeta, @Nonnull ItemMeta itemMeta) {
        return sfItemMeta.getPersistentDataContainer().equals(itemMeta.getPersistentDataContainer());
    }

    static {
        ItemMeta itemMeta = NO_ITEM.getItemMeta();
        PersistentDataAPI.setBoolean((PersistentDataHolder)itemMeta, (NamespacedKey)Keys.newKey("display"), (boolean)true);
        NO_ITEM.setItemMeta(itemMeta);
    }
}

