/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.NetworkRoot;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.slimefun.network.AdminDebuggable;
import io.github.sefiraat.networks.utils.Theme;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public abstract class NetworkObject
extends SlimefunItem
implements AdminDebuggable {
    private final NodeType nodeType;
    private final List<Integer> slotsToDrop = new ArrayList<Integer>();
    protected static final Set<BlockFace> CHECK_FACES = Set.of(BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST);

    protected NetworkObject(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, NodeType type) {
        this(itemGroup, item, recipeType, recipe, null, type);
    }

    protected NetworkObject(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput, NodeType type) {
        super(itemGroup, item, recipeType, recipe, recipeOutput);
        this.nodeType = type;
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return NetworkObject.this.runSync();
            }

            public void tick(Block b, SlimefunItem item, Config data) {
                NetworkObject.this.addToRegistry(b);
            }
        }, new BlockBreakHandler(false, false){

            @ParametersAreNonnullByDefault
            public void onPlayerBreak(BlockBreakEvent event, ItemStack item, List<ItemStack> drops) {
                NetworkObject.this.preBreak(event);
                NetworkObject.this.onBreak(event);
            }
        }, new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent blockPlaceEvent) {
                NetworkObject.this.onPlace(blockPlaceEvent);
            }
        }, new ItemUseHandler(){

            public void onRightClick(PlayerRightClickEvent playerRightClickEvent) {
                NetworkObject.this.prePlace(playerRightClickEvent);
            }
        }});
    }

    protected void addToRegistry(@Nonnull Block block) {
        if (!NetworkStorage.getAllNetworkObjects().containsKey(block.getLocation())) {
            NodeDefinition nodeDefinition = new NodeDefinition(this.nodeType);
            NetworkStorage.getAllNetworkObjects().put(block.getLocation(), nodeDefinition);
        }
    }

    protected void preBreak(@Nonnull BlockBreakEvent event) {
    }

    protected void onBreak(@Nonnull BlockBreakEvent event) {
        Location location = event.getBlock().getLocation();
        BlockMenu blockMenu = BlockStorage.getInventory((Block)event.getBlock());
        if (blockMenu != null) {
            for (int i : this.slotsToDrop) {
                blockMenu.dropItems(location, new int[]{i});
            }
        }
        BlockStorage.clearBlockInfo((Location)location);
    }

    protected void prePlace(@Nonnull PlayerRightClickEvent event) {
        Optional blockOptional = event.getClickedBlock();
        Location controllerLocation = null;
        if (blockOptional.isPresent()) {
            Block block = (Block)blockOptional.get();
            Block target = block.getRelative(event.getClickedFace());
            this.addToRegistry(block);
            for (BlockFace checkFace : CHECK_FACES) {
                Block checkBlock = target.getRelative(checkFace);
                NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(checkBlock.getLocation());
                if (definition == null || definition.getNode() == null) continue;
                NetworkRoot networkRoot = definition.getNode().getRoot();
                if (controllerLocation == null) {
                    controllerLocation = networkRoot.getController();
                    continue;
                }
                if (controllerLocation.equals((Object)networkRoot.getController())) continue;
                this.cancelPlace(event);
            }
        }
    }

    protected void cancelPlace(PlayerRightClickEvent event) {
        event.getPlayer().sendMessage(Theme.ERROR.getColor() + "This placement would connect two controllers!");
        event.cancel();
    }

    protected void onPlace(@Nonnull BlockPlaceEvent event) {
    }

    public boolean runSync() {
        return false;
    }

    @Generated
    public NodeType getNodeType() {
        return this.nodeType;
    }

    @Generated
    public List<Integer> getSlotsToDrop() {
        return this.slotsToDrop;
    }
}

