/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.slimefun.NetworkSlimefunItems;
import io.github.sefiraat.networks.slimefun.network.NetworkObject;
import io.github.sefiraat.networks.utils.Theme;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NetworkGreedyBlock
extends NetworkObject {
    public static final int TEMPLATE_SLOT = 10;
    public static final int INPUT_SLOT = 16;
    private static final int[] BACKGROUND_SLOTS = new int[]{3, 4, 5, 12, 13, 14, 21, 22, 23};
    private static final int[] BACKGROUND_SLOTS_TEMPLATE = new int[]{0, 1, 2, 9, 11, 18, 19, 20};
    private static final int[] BACKGROUND_SLOTS_INPUT = new int[]{6, 7, 8, 15, 17, 24, 25, 26};
    private static final CustomItemStack TEMPLATE_BACKGROUND_STACK = new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, Theme.SUCCESS + "Store items matching", new String[0]);
    private static final CustomItemStack STORAGE_BACKGROUND_STACK = new CustomItemStack(Material.ORANGE_STAINED_GLASS_PANE, Theme.SUCCESS + "Storage", new String[0]);

    public NetworkGreedyBlock(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, NodeType.GREEDY_BLOCK);
        this.getSlotsToDrop().add(16);
        this.getSlotsToDrop().add(10);
    }

    public void postRegister() {
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                this.drawBackground(BACKGROUND_SLOTS);
                this.drawBackground((ItemStack)TEMPLATE_BACKGROUND_STACK, BACKGROUND_SLOTS_TEMPLATE);
                this.drawBackground((ItemStack)STORAGE_BACKGROUND_STACK, BACKGROUND_SLOTS_INPUT);
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return NetworkSlimefunItems.NETWORK_GREEDY_BLOCK.canUse(player, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return new int[]{16};
                }
                return new int[0];
            }
        };
    }
}

