/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.NetworkRoot;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.network.SupportedRecipes;
import io.github.sefiraat.networks.network.stackcaches.BlueprintInstance;
import io.github.sefiraat.networks.network.stackcaches.ItemRequest;
import io.github.sefiraat.networks.slimefun.NetworkSlimefunItems;
import io.github.sefiraat.networks.slimefun.network.NetworkObject;
import io.github.sefiraat.networks.slimefun.tools.CraftingBlueprint;
import io.github.sefiraat.networks.utils.Keys;
import io.github.sefiraat.networks.utils.StackUtils;
import io.github.sefiraat.networks.utils.Theme;
import io.github.sefiraat.networks.utils.datatypes.DataTypeMethods;
import io.github.sefiraat.networks.utils.datatypes.PersistentCraftingBlueprintType;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class NetworkAutoCrafter
extends NetworkObject {
    private static final int[] BACKGROUND_SLOTS = new int[]{3, 4, 5, 12, 13, 14, 21, 22, 23};
    private static final int[] BLUEPRINT_BACKGROUND = new int[]{0, 1, 2, 9, 11, 18, 19, 20};
    private static final int[] OUTPUT_BACKGROUND = new int[]{6, 7, 8, 15, 17, 24, 25, 26};
    private static final int BLUEPRINT_SLOT = 10;
    private static final int OUTPUT_SLOT = 16;
    public static final CustomItemStack BLUEPRINT_BACKGROUND_STACK = new CustomItemStack(Material.BLUE_STAINED_GLASS_PANE, Theme.PASSIVE + "Crafting Blueprint", new String[0]);
    public static final CustomItemStack OUTPUT_BACKGROUND_STACK = new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, Theme.PASSIVE + "Output", new String[0]);
    private final int chargePerCraft;
    private final boolean withholding;
    private static final Map<Location, BlueprintInstance> INSTANCE_MAP = new HashMap<Location, BlueprintInstance>();

    public NetworkAutoCrafter(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int chargePerCraft, boolean withholding) {
        super(itemGroup, item, recipeType, recipe, NodeType.CRAFTER);
        this.chargePerCraft = chargePerCraft;
        this.withholding = withholding;
        this.getSlotsToDrop().add(10);
        this.getSlotsToDrop().add(16);
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block block, SlimefunItem slimefunItem, Config config) {
                BlockMenu blockMenu = BlockStorage.getInventory((Block)block);
                if (blockMenu != null) {
                    NetworkAutoCrafter.this.addToRegistry(block);
                    NetworkAutoCrafter.this.craftPreFlight(blockMenu);
                }
            }
        }});
    }

    protected void craftPreFlight(@Nonnull BlockMenu blockMenu) {
        ItemStack blueprint;
        ItemStack stored;
        this.releaseCache(blockMenu);
        NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(blockMenu.getLocation());
        if (definition == null || definition.getNode() == null) {
            return;
        }
        NetworkRoot root = definition.getNode().getRoot();
        if (!this.withholding && (stored = blockMenu.getItemInSlot(16)) != null && stored.getType() != Material.AIR) {
            root.addItemStack(stored);
        }
        if ((blueprint = blockMenu.getItemInSlot(10)) == null || blueprint.getType() == Material.AIR) {
            return;
        }
        long networkCharge = root.getRootPower();
        if (networkCharge > (long)this.chargePerCraft) {
            ItemStack output;
            SlimefunItem item = SlimefunItem.getByItem((ItemStack)blueprint);
            if (!(item instanceof CraftingBlueprint)) {
                return;
            }
            BlueprintInstance instance = INSTANCE_MAP.get(blockMenu.getLocation());
            if (instance == null) {
                ItemMeta blueprintMeta = blueprint.getItemMeta();
                Optional<BlueprintInstance> optional = DataTypeMethods.getOptionalCustom((PersistentDataHolder)blueprintMeta, Keys.BLUEPRINT_INSTANCE, PersistentCraftingBlueprintType.TYPE);
                if (optional.isEmpty()) {
                    return;
                }
                instance = optional.get();
                this.setCache(blockMenu, instance);
            }
            if (!((output = blockMenu.getItemInSlot(16)) == null || output.getType() == Material.AIR || output.getAmount() + instance.getItemStack().getAmount() < output.getMaxStackSize() && StackUtils.itemsMatch(instance, output, true))) {
                return;
            }
            if (this.tryCraft(blockMenu, instance, root)) {
                root.removeRootPower(this.chargePerCraft);
            }
        }
    }

    private boolean tryCraft(@Nonnull BlockMenu blockMenu, @Nonnull BlueprintInstance instance, @Nonnull NetworkRoot root) {
        Object requested;
        Object[] inputs = new ItemStack[9];
        HashMap<ItemStack, Integer> requiredItems = new HashMap<ItemStack, Integer>();
        for (int i = 0; i < 9; ++i) {
            requested = instance.getRecipeItems()[i];
            if (requested == null) continue;
            requiredItems.merge((ItemStack)requested, 1, Integer::sum);
        }
        for (Map.Entry entry : requiredItems.entrySet()) {
            if (root.contains(new ItemRequest((ItemStack)entry.getKey(), (Integer)entry.getValue()))) continue;
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack;
            requested = instance.getRecipeItems()[i];
            inputs[i] = requested != null ? (itemStack = root.getItemStack(new ItemRequest(instance.getRecipeItems()[i], 1))) : null;
        }
        ItemStack crafted = null;
        for (Map.Entry entry : SupportedRecipes.getRecipes().entrySet()) {
            if (!SupportedRecipes.testRecipe((ItemStack[])inputs, (ItemStack[])entry.getKey())) continue;
            crafted = ((ItemStack)entry.getValue()).clone();
            break;
        }
        if (crafted == null) {
            instance.generateVanillaRecipe(blockMenu.getLocation().getWorld());
            if (instance.getRecipe() == null) {
                this.returnItems(root, (ItemStack[])inputs);
                return false;
            }
            if (Arrays.equals(instance.getRecipeItems(), inputs)) {
                this.setCache(blockMenu, instance);
                crafted = instance.getRecipe().getResult();
            }
        }
        if (crafted == null || crafted.getType() == Material.AIR) {
            this.returnItems(root, (ItemStack[])inputs);
            return false;
        }
        Location location = blockMenu.getLocation().clone().add(0.5, 1.1, 0.5);
        if (root.isDisplayParticles()) {
            location.getWorld().spawnParticle(Particle.WAX_OFF, location, 0, 0.0, 4.0, 0.0);
        }
        blockMenu.pushItem(crafted, new int[]{16});
        return true;
    }

    private void returnItems(@Nonnull NetworkRoot root, @Nonnull ItemStack[] inputs) {
        for (ItemStack input : inputs) {
            if (input == null) continue;
            root.addItemStack(input);
        }
    }

    public void releaseCache(@Nonnull BlockMenu blockMenu) {
        if (blockMenu.hasViewer()) {
            INSTANCE_MAP.remove(blockMenu.getLocation());
        }
    }

    public void setCache(@Nonnull BlockMenu blockMenu, @Nonnull BlueprintInstance blueprintInstance) {
        if (!blockMenu.hasViewer()) {
            INSTANCE_MAP.putIfAbsent(blockMenu.getLocation().clone(), blueprintInstance);
        }
    }

    public void postRegister() {
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                this.drawBackground(BACKGROUND_SLOTS);
                this.drawBackground((ItemStack)BLUEPRINT_BACKGROUND_STACK, BLUEPRINT_BACKGROUND);
                this.drawBackground((ItemStack)OUTPUT_BACKGROUND_STACK, OUTPUT_BACKGROUND);
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return NetworkSlimefunItems.NETWORK_AUTO_CRAFTER.canUse(player, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (NetworkAutoCrafter.this.withholding && flow == ItemTransportFlow.WITHDRAW) {
                    return new int[]{16};
                }
                return new int[0];
            }
        };
    }
}

