/*
 * Decompiled with CFR 0.152.
 */
package io.github.bakedlibs.dough.blocks;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public final class Vein {
    private static final BlockFace[] faces = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH_EAST, BlockFace.NORTH_WEST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_WEST};

    private Vein() {
    }

    public static List<Block> find(Block b, int limit) {
        return Vein.find(b, limit, block -> block.getType() == b.getType());
    }

    public static List<Block> find(Block b, int limit, Predicate<Block> predicate) {
        LinkedList<Block> list = new LinkedList<Block>();
        Vein.expand(b, list, limit, predicate);
        return list;
    }

    private static void expand(Block anchor, List<Block> list, int limit, Predicate<Block> predicate) {
        if (list.size() >= limit) {
            return;
        }
        list.add(anchor);
        for (BlockFace face : faces) {
            Block next = anchor.getRelative(face);
            if (list.contains(next) || !predicate.test(next)) continue;
            Vein.expand(next, list, limit, predicate);
        }
    }
}

