/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network.grid;

import io.github.sefiraat.networks.slimefun.NetworkSlimefunItems;
import io.github.sefiraat.networks.slimefun.network.grid.AbstractGrid;
import io.github.sefiraat.networks.slimefun.network.grid.GridCache;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NetworkGrid
extends AbstractGrid {
    private static final int[] BACKGROUND_SLOTS = new int[]{17, 26};
    private static final int[] DISPLAY_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 27, 28, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 49, 50, 51, 52};
    private static final int INPUT_SLOT = 8;
    private static final int CHANGE_SORT = 26;
    private static final int FILTER = 35;
    private static final int PAGE_PREVIOUS = 44;
    private static final int PAGE_NEXT = 53;
    private static final Map<Location, GridCache> CACHE_MAP = new HashMap<Location, GridCache>();

    public NetworkGrid(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.getSlotsToDrop().add(this.getInputSlot());
    }

    @Override
    @Nonnull
    protected BlockMenuPreset getPreset() {
        return new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                this.drawBackground(NetworkGrid.this.getBackgroundSlots());
                this.setSize(54);
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return NetworkSlimefunItems.NETWORK_GRID.canUse(player, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                NetworkGrid.this.getCacheMap().put(menu.getLocation(), new GridCache(0, 0, GridCache.SortOrder.ALPHABETICAL));
                menu.replaceExistingItem(NetworkGrid.this.getPagePrevious(), (ItemStack)NetworkGrid.this.getPagePreviousStack());
                menu.addMenuClickHandler(NetworkGrid.this.getPagePrevious(), (p, slot, item, action) -> {
                    GridCache gridCache;
                    gridCache.setPage((gridCache = NetworkGrid.this.getCacheMap().get(menu.getLocation())).getPage() <= 0 ? 0 : gridCache.getPage() - 1);
                    NetworkGrid.this.getCacheMap().put(menu.getLocation(), gridCache);
                    return false;
                });
                menu.replaceExistingItem(NetworkGrid.this.getPageNext(), (ItemStack)NetworkGrid.this.getPageNextStack());
                menu.addMenuClickHandler(NetworkGrid.this.getPageNext(), (p, slot, item, action) -> {
                    GridCache gridCache;
                    gridCache.setPage((gridCache = NetworkGrid.this.getCacheMap().get(menu.getLocation())).getPage() >= gridCache.getMaxPages() ? gridCache.getMaxPages() : gridCache.getPage() + 1);
                    NetworkGrid.this.getCacheMap().put(menu.getLocation(), gridCache);
                    return false;
                });
                menu.replaceExistingItem(NetworkGrid.this.getChangeSort(), (ItemStack)NetworkGrid.this.getChangeSortStack());
                menu.addMenuClickHandler(NetworkGrid.this.getChangeSort(), (p, slot, item, action) -> {
                    GridCache gridCache = NetworkGrid.this.getCacheMap().get(menu.getLocation());
                    if (gridCache.getSortOrder() == GridCache.SortOrder.ALPHABETICAL) {
                        gridCache.setSortOrder(GridCache.SortOrder.NUMBER);
                    } else {
                        gridCache.setSortOrder(GridCache.SortOrder.ALPHABETICAL);
                    }
                    NetworkGrid.this.getCacheMap().put(menu.getLocation(), gridCache);
                    return false;
                });
                menu.replaceExistingItem(NetworkGrid.this.getFilterSlot(), (ItemStack)NetworkGrid.this.getFilterStack());
                menu.addMenuClickHandler(NetworkGrid.this.getFilterSlot(), (p, slot, item, action) -> {
                    GridCache gridCache = NetworkGrid.this.getCacheMap().get(menu.getLocation());
                    return NetworkGrid.this.setFilter(p, menu, gridCache, action);
                });
                for (int displaySlot : NetworkGrid.this.getDisplaySlots()) {
                    menu.replaceExistingItem(displaySlot, null);
                    menu.addMenuClickHandler(displaySlot, (p, slot, item, action) -> false);
                }
            }
        };
    }

    @Override
    @Nonnull
    public Map<Location, GridCache> getCacheMap() {
        return CACHE_MAP;
    }

    @Override
    public int[] getBackgroundSlots() {
        return BACKGROUND_SLOTS;
    }

    @Override
    public int[] getDisplaySlots() {
        return DISPLAY_SLOTS;
    }

    @Override
    public int getInputSlot() {
        return 8;
    }

    @Override
    public int getChangeSort() {
        return 26;
    }

    @Override
    public int getPagePrevious() {
        return 44;
    }

    @Override
    public int getPageNext() {
        return 53;
    }

    @Override
    protected int getFilterSlot() {
        return 35;
    }
}

