/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.network;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.Networks;
import io.github.sefiraat.networks.network.NetworkRoot;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.slimefun.network.NetworkController;
import io.github.sefiraat.networks.slimefun.network.NetworkPowerNode;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class NetworkNode {
    protected static final Set<BlockFace> VALID_FACES = EnumSet.of(BlockFace.UP, new BlockFace[]{BlockFace.DOWN, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST});
    protected final Set<NetworkNode> childrenNodes = new HashSet<NetworkNode>();
    protected NetworkNode parent = null;
    protected NetworkRoot root = null;
    protected Location nodePosition;
    protected NodeType nodeType;
    protected long power;

    public NetworkNode(Location location, NodeType type) {
        this.nodePosition = location;
        this.nodeType = type;
        this.power = this.retrieveBlockCharge();
    }

    public void addChild(@Nonnull NetworkNode child) {
        child.setParent(this);
        child.setRoot(this.getRoot());
        this.root.addRootPower(child.getPower());
        this.root.registerNode(child.nodePosition, child.nodeType);
        this.childrenNodes.add(child);
    }

    @Nonnull
    public Location getNodePosition() {
        return this.nodePosition;
    }

    @Nonnull
    public NodeType getNodeType() {
        return this.nodeType;
    }

    public boolean networkContains(@Nonnull NetworkNode networkNode) {
        return this.networkContains(networkNode.nodePosition);
    }

    public boolean networkContains(@Nonnull Location location) {
        return this.root.getNodeLocations().contains(location);
    }

    @Nonnull
    public NetworkRoot getRoot() {
        return this.root;
    }

    private void setRoot(NetworkRoot root) {
        this.root = root;
    }

    public NetworkNode getParent() {
        return this.parent;
    }

    private void setParent(NetworkNode parent) {
        this.parent = parent;
    }

    public Set<NetworkNode> getChildrenNodes() {
        return this.childrenNodes;
    }

    public void addAllChildren() {
        for (BlockFace face : VALID_FACES) {
            Location testLocation = this.nodePosition.clone().add(face.getDirection());
            NodeDefinition testDefinition = NetworkStorage.getAllNetworkObjects().get(testLocation);
            if (testDefinition == null) continue;
            NodeType testType = testDefinition.getType();
            if (testType == NodeType.CONTROLLER && !testLocation.equals((Object)this.getRoot().nodePosition)) {
                this.killAdditionalController(testLocation);
                continue;
            }
            if (testType == NodeType.CONTROLLER || this.networkContains(testLocation)) continue;
            if (this.getRoot().getNodeCount() >= this.root.getMaxNodes()) {
                this.getRoot().setOverburdened(true);
                return;
            }
            NetworkNode networkNode = new NetworkNode(testLocation, testType);
            this.addChild(networkNode);
            networkNode.addAllChildren();
            testDefinition.setNode(networkNode);
            NetworkStorage.getAllNetworkObjects().put(testLocation, testDefinition);
        }
    }

    private void killAdditionalController(final @Nonnull Location location) {
        final Block block = location.getBlock();
        final ItemStack toDrop = BlockStorage.retrieve((Block)block);
        if (toDrop != null) {
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    location.getWorld().dropItemNaturally(location, toDrop);
                    block.setType(Material.AIR);
                }
            };
            runnable.runTask((Plugin)Networks.getInstance());
            NetworkController.wipeNetwork(location);
        }
    }

    protected long retrieveBlockCharge() {
        if (this.nodeType == NodeType.POWER_NODE) {
            int blockCharge = 0;
            SlimefunItem item = BlockStorage.check((Location)this.nodePosition);
            SlimefunItem slimefunItem = item;
            if (slimefunItem instanceof NetworkPowerNode) {
                NetworkPowerNode powerNode = (NetworkPowerNode)slimefunItem;
                blockCharge = powerNode.getCharge(this.nodePosition);
            }
            return blockCharge;
        }
        return 0L;
    }

    public long getPower() {
        return this.power;
    }
}

