/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.utils;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.inventory.ItemStack;

public enum Theme {
    WARNING(ChatColor.YELLOW, "Warning"),
    ERROR(ChatColor.RED, "Error"),
    NOTICE(ChatColor.WHITE, "Notice"),
    PASSIVE(ChatColor.GRAY, ""),
    SUCCESS(ChatColor.GREEN, "Success"),
    MAIN(ChatColor.of((String)"#21588f"), "Alone"),
    CLICK_INFO(ChatColor.of((String)"#e4ed32"), "Click here"),
    RESEARCH(ChatColor.of((String)"#a60e03"), "Research"),
    CRAFTING(ChatColor.of((String)"#dbcea9"), "Crafting Material"),
    MACHINE(ChatColor.of((String)"#3295a8"), "Machine"),
    TOOL(ChatColor.of((String)"#6b32a8"), "Tool"),
    MECHANISM(ChatColor.of((String)"#3295a8"), "Mechanism"),
    FUEL(ChatColor.of((String)"#112211"), "Fossil Fuel"),
    MATERIAL_CLASS(ChatColor.of((String)"#a4c2ba"), "Material Class"),
    RECIPE_TYPE(ChatColor.of((String)"#ffe89c"), "Recipe Type"),
    GUIDE(ChatColor.of((String)"#444444"), "Guide");

    protected static final Theme[] cachedValues;
    private final ChatColor color;
    private final String loreLine;

    @ParametersAreNonnullByDefault
    private Theme(ChatColor color, String loreLine) {
        this.color = color;
        this.loreLine = loreLine;
    }

    @Nonnull
    public Particle.DustOptions getDustOptions(float size) {
        return new Particle.DustOptions(Color.fromRGB((int)this.color.getColor().getRed(), (int)this.color.getColor().getGreen(), (int)this.color.getColor().getBlue()), size);
    }

    public String toString() {
        return this.color.toString();
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static SlimefunItemStack themedSlimefunItemStack(String id, ItemStack itemStack, Theme themeType, String name, String ... lore) {
        ChatColor passiveColor = PASSIVE.getColor();
        ArrayList<Object> finalLore = new ArrayList<Object>();
        finalLore.add("");
        for (String s : lore) {
            finalLore.add(passiveColor + s);
        }
        finalLore.add("");
        finalLore.add(Theme.applyThemeToString(CLICK_INFO, themeType.getLoreLine()));
        return new SlimefunItemStack(id, itemStack, Theme.applyThemeToString(themeType, name), finalLore.toArray(new String[finalLore.size() - 1]));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static String applyThemeToString(Theme themeType, String string) {
        return themeType.getColor() + string;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static ItemStack themedItemStack(Material material, Theme themeType, String name, String ... lore) {
        ChatColor passiveColor = PASSIVE.getColor();
        ArrayList<Object> finalLore = new ArrayList<Object>();
        finalLore.add("");
        for (String s : lore) {
            finalLore.add(passiveColor + s);
        }
        finalLore.add("");
        finalLore.add(Theme.applyThemeToString(CLICK_INFO, themeType.getLoreLine()));
        return new CustomItemStack(material, Theme.applyThemeToString(themeType, name), finalLore.toArray(new String[finalLore.size() - 1]));
    }

    @Generated
    public ChatColor getColor() {
        return this.color;
    }

    @Generated
    public String getLoreLine() {
        return this.loreLine;
    }

    @Generated
    public static Theme[] getCachedValues() {
        return cachedValues;
    }

    static {
        cachedValues = Theme.values();
    }
}

