/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.utils;

import io.github.sefiraat.networks.network.stackcaches.ItemStackCache;
import io.github.sefiraat.networks.utils.Keys;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.AxolotlBucketMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.persistence.PersistentDataHolder;

public final class StackUtils {
    @Nonnull
    public static ItemStack getAsQuantity(@Nonnull ItemStack itemStack, int amount) {
        ItemStack clone = itemStack.clone();
        clone.setAmount(amount);
        return clone;
    }

    public static boolean itemsMatch(@Nullable ItemStack itemStack1, @Nullable ItemStack itemStack2) {
        return StackUtils.itemsMatch(new ItemStackCache(itemStack1), itemStack2, true);
    }

    public static boolean itemsMatch(@Nonnull ItemStackCache cache, @Nullable ItemStack itemStack, boolean checkLore) {
        if (cache.getItemStack() == null || itemStack == null) {
            return itemStack == null && cache.getItemStack() == null;
        }
        if (itemStack.getType() != cache.getItemType()) {
            return false;
        }
        if (!itemStack.hasItemMeta() || !cache.getItemStack().hasItemMeta()) {
            return itemStack.hasItemMeta() == cache.getItemStack().hasItemMeta();
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemMeta cachedMeta = cache.getItemMeta();
        if (!itemMeta.getClass().equals(cachedMeta.getClass())) {
            return false;
        }
        if (StackUtils.canQuickEscapeMetaVariant(itemMeta, cachedMeta)) {
            return false;
        }
        if (itemMeta.hasDisplayName() != cachedMeta.hasDisplayName()) {
            return false;
        }
        boolean hasCustomOne = itemMeta.hasCustomModelData();
        boolean hasCustomTwo = cachedMeta.hasCustomModelData();
        if (hasCustomOne ? !hasCustomTwo || itemMeta.getCustomModelData() != cachedMeta.getCustomModelData() : hasCustomTwo) {
            return false;
        }
        if (!itemMeta.getPersistentDataContainer().equals(cachedMeta.getPersistentDataContainer())) {
            return false;
        }
        if (!itemMeta.getEnchants().equals(cachedMeta.getEnchants())) {
            return false;
        }
        if (!itemMeta.getItemFlags().equals(cachedMeta.getItemFlags())) {
            return false;
        }
        if (checkLore && !Objects.equals(itemMeta.getLore(), cachedMeta.getLore())) {
            return false;
        }
        Optional optionalStackId1 = Slimefun.getItemDataService().getItemData(itemMeta);
        Optional optionalStackId2 = Slimefun.getItemDataService().getItemData(cachedMeta);
        if (optionalStackId1.isPresent() && optionalStackId2.isPresent()) {
            return ((String)optionalStackId1.get()).equals(optionalStackId2.get());
        }
        return !itemMeta.hasDisplayName() || itemMeta.getDisplayName().equals(cachedMeta.getDisplayName());
    }

    public static boolean canQuickEscapeMetaVariant(@Nonnull ItemMeta metaOne, @Nonnull ItemMeta metaTwo) {
        BundleMeta instanceTwo;
        BundleMeta instanceOne;
        Damageable instanceTwo2;
        Damageable instanceOne2;
        ItemMeta itemMeta = metaOne;
        if (itemMeta instanceof Damageable) {
            instanceOne2 = (Damageable)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof Damageable) {
                instanceTwo2 = (Damageable)itemMeta;
                if (instanceOne2.getDamage() != instanceTwo2.getDamage()) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof AxolotlBucketMeta) {
            instanceOne2 = (AxolotlBucketMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof AxolotlBucketMeta) {
                instanceTwo2 = (AxolotlBucketMeta)itemMeta;
                if (instanceOne2.hasVariant() != instanceTwo2.hasVariant()) {
                    return true;
                }
                if (!instanceOne2.hasVariant() || !instanceTwo2.hasVariant()) {
                    return true;
                }
                if (instanceOne2.getVariant() != instanceTwo2.getVariant()) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof BannerMeta) {
            instanceOne2 = (BannerMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof BannerMeta) {
                instanceTwo2 = (BannerMeta)itemMeta;
                if (!instanceOne2.getPatterns().equals(instanceTwo2.getPatterns())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof BookMeta) {
            instanceOne2 = (BookMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof BookMeta) {
                instanceTwo2 = (BookMeta)itemMeta;
                if (instanceOne2.getPageCount() != instanceTwo2.getPageCount()) {
                    return true;
                }
                if (!Objects.equals(instanceOne2.getAuthor(), instanceTwo2.getAuthor())) {
                    return true;
                }
                if (!Objects.equals(instanceOne2.getTitle(), instanceTwo2.getTitle())) {
                    return true;
                }
                if (!Objects.equals(instanceOne2.getGeneration(), instanceTwo2.getGeneration())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof BundleMeta) {
            instanceOne = (BundleMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof BundleMeta) {
                instanceTwo = (BundleMeta)itemMeta;
                if (instanceOne.hasItems() != instanceTwo.hasItems()) {
                    return true;
                }
                if (!instanceOne.getItems().equals(instanceTwo.getItems())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof CompassMeta) {
            instanceOne = (CompassMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof CompassMeta) {
                instanceTwo = (CompassMeta)itemMeta;
                if (instanceOne.isLodestoneTracked() != instanceTwo.isLodestoneTracked()) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getLodestone(), instanceTwo.getLodestone())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof CrossbowMeta) {
            instanceOne = (CrossbowMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof CrossbowMeta) {
                instanceTwo = (CrossbowMeta)itemMeta;
                if (instanceOne.hasChargedProjectiles() != instanceTwo.hasChargedProjectiles()) {
                    return true;
                }
                if (!instanceOne.getChargedProjectiles().equals(instanceTwo.getChargedProjectiles())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof EnchantmentStorageMeta) {
            instanceOne = (EnchantmentStorageMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof EnchantmentStorageMeta) {
                instanceTwo = (EnchantmentStorageMeta)itemMeta;
                if (instanceOne.hasStoredEnchants() != instanceTwo.hasStoredEnchants()) {
                    return true;
                }
                if (!instanceOne.getStoredEnchants().equals(instanceTwo.getStoredEnchants())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof FireworkEffectMeta) {
            instanceOne = (FireworkEffectMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof FireworkEffectMeta) {
                instanceTwo = (FireworkEffectMeta)itemMeta;
                if (!Objects.equals(instanceOne.getEffect(), instanceTwo.getEffect())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof FireworkMeta) {
            instanceOne2 = (FireworkMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof FireworkMeta) {
                instanceTwo2 = (FireworkMeta)itemMeta;
                if (instanceOne2.getPower() != instanceTwo2.getPower()) {
                    return true;
                }
                if (!instanceOne2.getEffects().equals(instanceTwo2.getEffects())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof LeatherArmorMeta) {
            instanceOne = (LeatherArmorMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof LeatherArmorMeta) {
                instanceTwo = (LeatherArmorMeta)itemMeta;
                if (!instanceOne.getColor().equals((Object)instanceTwo.getColor())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof MapMeta) {
            instanceOne = (MapMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof MapMeta) {
                instanceTwo = (MapMeta)itemMeta;
                if (instanceOne.hasMapView() != instanceTwo.hasMapView()) {
                    return true;
                }
                if (instanceOne.hasLocationName() != instanceTwo.hasLocationName()) {
                    return true;
                }
                if (instanceOne.hasColor() != instanceTwo.hasColor()) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getMapView(), instanceTwo.getMapView())) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getLocationName(), instanceTwo.getLocationName())) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getColor(), instanceTwo.getColor())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof PotionMeta) {
            instanceOne = (PotionMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof PotionMeta) {
                instanceTwo = (PotionMeta)itemMeta;
                if (!instanceOne.getBasePotionData().equals((Object)instanceTwo.getBasePotionData())) {
                    return true;
                }
                if (instanceOne.hasCustomEffects() != instanceTwo.hasCustomEffects()) {
                    return true;
                }
                if (instanceOne.hasColor() != instanceTwo.hasColor()) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getColor(), instanceTwo.getColor())) {
                    return true;
                }
                if (!instanceOne.getCustomEffects().equals(instanceTwo.getCustomEffects())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof SkullMeta) {
            instanceOne = (SkullMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof SkullMeta) {
                instanceTwo = (SkullMeta)itemMeta;
                if (instanceOne.hasOwner() != instanceTwo.hasOwner()) {
                    return true;
                }
                if (!Objects.equals(instanceOne.getOwningPlayer(), instanceTwo.getOwningPlayer())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof SuspiciousStewMeta) {
            instanceOne = (SuspiciousStewMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof SuspiciousStewMeta) {
                instanceTwo = (SuspiciousStewMeta)itemMeta;
                if (!Objects.equals(instanceOne.getCustomEffects(), instanceTwo.getCustomEffects())) {
                    return true;
                }
            }
        }
        if ((itemMeta = metaOne) instanceof TropicalFishBucketMeta) {
            instanceOne = (TropicalFishBucketMeta)itemMeta;
            itemMeta = metaTwo;
            if (itemMeta instanceof TropicalFishBucketMeta) {
                instanceTwo = (TropicalFishBucketMeta)itemMeta;
                if (instanceOne.hasVariant() != instanceTwo.hasVariant()) {
                    return true;
                }
                if (!instanceOne.getPattern().equals((Object)instanceTwo.getPattern())) {
                    return true;
                }
                if (!instanceOne.getBodyColor().equals((Object)instanceTwo.getBodyColor())) {
                    return true;
                }
                if (!instanceOne.getPatternColor().equals((Object)instanceTwo.getPatternColor())) {
                    return true;
                }
            }
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public static void putOnCooldown(ItemStack itemStack, int durationInSeconds) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            PersistentDataAPI.setLong((PersistentDataHolder)itemMeta, (NamespacedKey)Keys.ON_COOLDOWN, (long)(System.currentTimeMillis() + (long)durationInSeconds * 1000L));
            itemStack.setItemMeta(itemMeta);
        }
    }

    @ParametersAreNonnullByDefault
    public static boolean isOnCooldown(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            long cooldownUntil = PersistentDataAPI.getLong((PersistentDataHolder)itemMeta, (NamespacedKey)Keys.ON_COOLDOWN, (long)0L);
            return System.currentTimeMillis() < cooldownUntil;
        }
        return false;
    }

    @Generated
    private StackUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

