/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.network.stackcaches.ItemRequest;
import io.github.sefiraat.networks.slimefun.NetworkSlimefunItems;
import io.github.sefiraat.networks.slimefun.network.NetworkObject;
import io.github.sefiraat.networks.utils.Theme;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.List;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class NetworkPurger
extends NetworkObject {
    private static final int[] BACKGROUND_SLOTS = new int[]{0, 1, 2, 6, 7, 8, 9, 10, 11, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    private static final int TEST_ITEM_SLOT = 13;
    private static final int[] TEST_ITEM_BACKDROP = new int[]{3, 4, 5, 12, 14, 21, 22, 23};
    private static final CustomItemStack TEST_BACKDROP_STACK = new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, Theme.SUCCESS + "Purge Item Matching", new String[0]);
    private final ItemSetting<Integer> tickRate = new IntRangeSetting((SlimefunItem)this, "tick_rate", 1, 1, 10);

    public NetworkPurger(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, NodeType.PURGER);
        this.addItemSetting(new ItemSetting[]{this.tickRate});
        this.getSlotsToDrop().add(13);
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){
            private int tick = 1;

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block block, SlimefunItem item, Config data) {
                if (this.tick <= 1) {
                    BlockMenu blockMenu = BlockStorage.getInventory((Block)block);
                    NetworkPurger.this.addToRegistry(block);
                    NetworkPurger.this.tryKillItem(blockMenu);
                }
            }

            public void uniqueTick() {
                this.tick = this.tick <= 1 ? (Integer)NetworkPurger.this.tickRate.getValue() : this.tick - 1;
            }
        }, new BlockBreakHandler(true, true){

            public void onPlayerBreak(BlockBreakEvent e, ItemStack item, List<ItemStack> drops) {
                BlockMenu blockMenu = BlockStorage.getInventory((Block)e.getBlock());
                blockMenu.dropItems(blockMenu.getLocation(), new int[]{13});
            }
        }});
    }

    private void tryKillItem(@Nonnull BlockMenu blockMenu) {
        NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(blockMenu.getLocation());
        if (definition == null || definition.getNode() == null) {
            return;
        }
        ItemStack testItem = blockMenu.getItemInSlot(13);
        if (testItem == null) {
            return;
        }
        ItemStack clone = testItem.clone();
        clone.setAmount(1);
        ItemRequest itemRequest = new ItemRequest(clone, clone.getMaxStackSize());
        ItemStack retrieved = definition.getNode().getRoot().getItemStack(itemRequest);
        if (retrieved != null) {
            retrieved.setAmount(0);
            Location location = blockMenu.getLocation().clone().add(0.5, 1.2, 0.5);
            if (definition.getNode().getRoot().isDisplayParticles()) {
                location.getWorld().spawnParticle(Particle.SMOKE_NORMAL, location, 0, 0.0, 0.05, 0.0);
            }
        }
    }

    public void postRegister() {
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                this.drawBackground(BACKGROUND_SLOTS);
                this.drawBackground((ItemStack)TEST_BACKDROP_STACK, TEST_ITEM_BACKDROP);
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return NetworkSlimefunItems.NETWORK_PURGER.canUse(player, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }
        };
    }
}

